
--run as twitcher

DROP TABLE IF EXISTS dx_sandbox.metric_cme_helper_extension_list;
CREATE TABLE dx_sandbox.metric_cme_helper_extension_list AS

WITH

the_extensions AS (

SELECT game_flattened::VARCHAR(100), extension_id::VARCHAR(32), TRUE::BOOLEAN AS flag_count_cme_ugc, TRUE::BOOLEAN AS flag_count_cme_premium
FROM dx_metadata.official_content_matched_extensions

UNION

SELECT ''::VARCHAR(100) AS game_flattened, extension_id::VARCHAR(32), FALSE::BOOLEAN AS flag_count_cme_ugc, TRUE::BOOLEAN AS flag_count_cme_premium
FROM dx_sandbox.premium_channel_extensions
WHERE flag_is_content_matched = TRUE
)


-- group by extension_id to ensure one row per extension
, the_extensions_grouped AS (
  SELECT MAX(game_flattened) AS game_flattened, extension_id, BOOL_OR(flag_count_cme_ugc) AS flag_count_cme_ugc, BOOL_OR(flag_count_cme_premium) AS flag_count_cme_premium
  FROM the_extensions
  GROUP BY extension_id
)

, the_extensions_final AS (
  SELECT game_flattened, base.extension_id, ael.extension_name, flag_count_cme_ugc, flag_count_cme_premium
  FROM the_extensions_grouped AS base
  LEFT JOIN dx_metadata.all_extensions_latest AS ael ON base.extension_id = ael.extension_id
)

SELECT * FROM the_extensions_final

;
