--NOTE: AS OF 2019-11-08, only have data for desktop app and web
-- so search for the string below to change if tracking event changes
-- LOWER(base.platform) IN ('desktop', 'web') --exclude mobile_web since its incorrect data

--NOTE: create a table to support the "numerator" of the cme metric
--SPEC FOR ---> dx_sandbox.metric_cme_helper_hw_with_extension
-- the_day
-- channel_id
-- the_game
-- platform
-- flag_ugc_oo_channel
-- extension_id
-- flag_extension_count_towards_cme
-- hw_with_extension


-- --Create the Table with explicit schema types  NOTE: IF NOT EXISTS IS AN OPTIONAL KEYWORD
-- CREATE TABLE IF NOT EXISTS dx_sandbox.metric_cme_helper_hw_with_extension (
--     the_day                                 DATE sortkey
--     , channel_id                            BIGINT
--     , the_game                              VARCHAR(500) distkey
--     , platform                              VARCHAR(50)
--     , flag_ugc_oo_channel                   VARCHAR(25)
--     , extension_id                          VARCHAR(32)
--     , flag_extension_count_towards_cme      BOOLEAN
--     , hw_with_extension                     FLOAT
-- );



-- CHANGE the_index_date IF YOU WANT TO CHANGE THE RELATIVE DATE
CREATE TEMP TABLE the_dates_table AS (
  SELECT DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours'))::DATE AS the_index_date --today's start date
);

--DELETE THE DATA FOR THE DAY YOU ARE GOING TO BE ADDING IN
PREPARE the_delete_function_metric_cme_helper_hw_with_extension (BIGINT) AS
DELETE FROM dx_sandbox.metric_cme_helper_hw_with_extension
WHERE the_day = DATEADD(  day, $1, (SELECT the_index_date FROM the_dates_table)  )
;


--THEN CREATE A the_temp_table BASED ON THAT SCHEMA
CREATE TEMP TABLE the_temp_table (LIKE dx_sandbox.metric_cme_helper_hw_with_extension);

--THEN WRITE YOUR SQL CODE FOR THE INSERT FUNCTION
PREPARE the_insert_function_metric_cme_helper_hw_with_extension (BIGINT) AS
INSERT INTO the_temp_table (



  WITH
  the_parameter_input AS (
    SELECT DATEADD(  day, $1, (SELECT the_index_date FROM the_dates_table)  ) AS the_day_to_refresh_data_for
  )
  , the_constants_time AS (
    SELECT start_date, DATEADD(day, 1, start_date) AS end_date
    FROM (SELECT the_day_to_refresh_data_for AS start_date FROM the_parameter_input)
  )
  , extension_daily_mw AS (
    SELECT base.the_day
    , base.channel_id
    , f_game_flattened(base.game) As the_game
    , base.platform
    , base.extension_id
    , SUM(base.mw::FLOAT/60) AS hw
    FROM cubes.extension_daily_mw AS base
    WHERE
      (SELECT start_date FROM the_constants_time)<=the_day AND the_day<(SELECT end_date FROM the_constants_time)
      AND LOWER(base.platform) IN ('desktop', 'web') --exclude mobile_web since its incorrect data
      AND base.channel_id IS NOT NULL
      AND game IS NOT NULL
    GROUP BY 1,2,3,4,5
  )
  , channel_daily_status AS (
    SELECT the_date, channel_id, tier, CASE WHEN tier IN ('T5: Premium') THEN 'O&O Channel' ELSE 'UGC Channel' END AS flag_ugc_oo_channel
    FROM cubes.channel_daily_status
    WHERE
      (SELECT start_date FROM the_constants_time)<=the_date AND the_date<(SELECT end_date FROM the_constants_time)
    GROUP BY 1,2,3,4
  )
  , join_data AS (
    SELECT base.the_day
    , base.channel_id
    , base.the_game
    , base.platform
    , base.extension_id
    , NVL(cds.tier, 'NULL: NOT STREAM LAST 30 DAYS') AS tier
    , NVL(cds.flag_ugc_oo_channel, 'UGC Channel') AS flag_ugc_oo_channel
    , base.hw
    FROM extension_daily_mw AS base
    LEFT JOIN channel_daily_status AS cds ON base.the_day = cds.the_date AND base.channel_id = cds.channel_id
  )




  , final_data AS (
    SELECT
      the_day::DATE
      , channel_id::BIGINT
      , the_game::VARCHAR
      , platform::VARCHAR
      , flag_ugc_oo_channel::VARCHAR
      , base.extension_id::VARCHAR
      , CASE
          WHEN flag_ugc_oo_channel = 'UGC Channel' AND base.the_game = ext.game_flattened AND base.extension_id = ext.extension_id
          THEN flag_count_cme_ugc

          WHEN flag_ugc_oo_channel = 'O&O Channel' AND base.extension_id = ext.extension_id
          THEN flag_count_cme_premium

          ELSE FALSE
        END AS flag_extension_count_towards_cme
      , base.hw::FLOAT
    FROM join_data AS base
    LEFT JOIN dx_sandbox.metric_cme_helper_extension_list AS ext ON base.extension_id = ext.extension_id
  )


  SELECT * FROM final_data



);



--RUN INSERT AND DELETE



EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-1); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-1);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-2); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-2);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_metric_cme_helper_hw_with_extension (-3); EXECUTE the_delete_function_metric_cme_helper_hw_with_extension (-3);   INSERT INTO dx_sandbox.metric_cme_helper_hw_with_extension    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
