-- 1. For activated extensions across all channels as of 2017-10-11, what % are panel and what % are overlay?
-- This will inform the importance of panel extensions


WITH
the_timeframe AS (
SELECT '2017-05-24 13:00:00'::timestamp AS start_time
, '2017-10-24 23:59:59'::timestamp AS end_time
)

, activate_logs AS (
SELECT extension_id, user_id, MAX(time) as last_time_activate
FROM logs.extension_activate
WHERE time>=(SELECT start_time FROM the_timeframe) AND time<=(SELECT end_time FROM the_timeframe)
GROUP BY 1,2
)
, deactivate_logs AS (
SELECT extension_id, user_id, MAX(time) as last_time_deactivate
FROM logs.extension_deactivate
WHERE time>=(SELECT start_time FROM the_timeframe) AND time<=(SELECT end_time FROM the_timeframe)
GROUP BY 1,2
)
--uninstall is an implicit deactivate
, uninstall_logs AS (
SELECT extension_id, user_id, MAX(time) as last_time_uninstall
FROM logs.extension_uninstall
WHERE time>=(SELECT start_time FROM the_timeframe) AND time<=(SELECT end_time FROM the_timeframe)
GROUP BY 1,2
)
, extension_logs_step1 AS (
SELECT allm.*, dllm.last_time_deactivate
, CASE WHEN allm.last_time_activate > dllm.last_time_deactivate THEN 1
WHEN allm.last_time_activate IS NOT NULL AND dllm.last_time_deactivate IS NULL THEN 1
ELSE 0 END AS flag_is_activated_step1
FROM activate_logs AS allm
LEFT JOIN deactivate_logs AS dllm ON allm.extension_id = dllm.extension_id AND allm.user_id = dllm.user_id
)

, extension_logs_final AS (
SELECT els.*, ullm.last_time_uninstall
, CASE WHEN els.last_time_activate > ullm.last_time_uninstall THEN 1
WHEN els.last_time_activate IS NOT NULL AND ullm.last_time_uninstall IS NULL THEN 1
ELSE 0 END AS flag_is_activated
FROM extension_logs_step1 AS els
LEFT JOIN uninstall_logs AS ullm ON els.extension_id = ullm.extension_id AND els.user_id = ullm.user_id
WHERE els.flag_is_activated_step1=1
)

SELECT extension_anchor, REPLACE(extension_name, ',', '') AS extension_name, COUNT(DISTINCT user_id) AS distinct_channels, COUNT(1) AS net_activated_extensions_count
FROM
(
SELECT elf.*, rel.extension_name, rel.extension_anchor
FROM extension_logs_final AS elf
LEFT JOIN analysis.released_extensions_latest AS rel ON elf.extension_id = rel.extension_id
WHERE flag_is_activated=1
)
GROUP BY 1,2
ORDER BY 1,2
