-- 2. For the Top Clips Extension, pull the timestamp of when they went through funnel (i.e. testing to released), then pull the #net activations as of 2017-10-11
-- This will highlight a successful case study of a panel extension that is just a remix of some clips team features.

--net activated numbers for Top Clips Extension

WITH
the_timeframe AS (
SELECT '2017-05-24 13:00:00'::timestamp AS start_time
, '2017-10-23 23:59:59'::timestamp AS end_time
, 'rh6jq1q334hqc2rr1qlzqbvwlfl3x0' AS the_extension_id --TopClip    https://www.twitch.tv/ext/rh6jq1q334hqc2rr1qlzqbvwlfl3x0-0.0.4
)

, activate_logs AS (
SELECT extension_id, user_id, MAX(time) as last_time_activate
FROM logs.extension_activate
WHERE time>=(SELECT start_time FROM the_timeframe) AND time<=(SELECT end_time FROM the_timeframe)
AND extension_id = (SELECT the_extension_id FROM the_timeframe)
GROUP BY 1,2
)
, deactivate_logs AS (
SELECT extension_id, user_id, MAX(time) as last_time_deactivate
FROM logs.extension_deactivate
WHERE time>=(SELECT start_time FROM the_timeframe) AND time<=(SELECT end_time FROM the_timeframe)
AND extension_id = (SELECT the_extension_id FROM the_timeframe)
GROUP BY 1,2
)
--uninstall is an implicit deactivate
, uninstall_logs AS (
SELECT extension_id, user_id, MAX(time) as last_time_uninstall
FROM logs.extension_uninstall
WHERE time>=(SELECT start_time FROM the_timeframe) AND time<=(SELECT end_time FROM the_timeframe)
AND extension_id = (SELECT the_extension_id FROM the_timeframe)
GROUP BY 1,2
)
, extension_logs_step1 AS (
SELECT allm.*, dllm.last_time_deactivate
, CASE WHEN allm.last_time_activate > dllm.last_time_deactivate THEN 1
WHEN allm.last_time_activate IS NOT NULL AND dllm.last_time_deactivate IS NULL THEN 1
ELSE 0 END AS flag_is_activated_step1
FROM activate_logs AS allm
LEFT JOIN deactivate_logs AS dllm ON allm.extension_id = dllm.extension_id AND allm.user_id = dllm.user_id
)

, extension_logs_final AS (
SELECT els.*, ullm.last_time_uninstall
, CASE WHEN els.last_time_activate > ullm.last_time_uninstall THEN 1
WHEN els.last_time_activate IS NOT NULL AND ullm.last_time_uninstall IS NULL THEN 1
ELSE 0 END AS flag_is_activated
FROM extension_logs_step1 AS els
LEFT JOIN uninstall_logs AS ullm ON els.extension_id = ullm.extension_id AND els.user_id = ullm.user_id
WHERE els.flag_is_activated_step1=1
)

SELECT COUNT(DISTINCT user_id) AS channels, COUNT(1) AS active_extensions, COUNT(1)::float / COUNT(DISTINCT user_id)::float AS extensions_per_channel
FROM extension_logs_final
WHERE flag_is_activated=1
