-- CHANGE the_index_date IF YOU WANT TO CHANGE THE RELATIVE DATE 
CREATE TEMP TABLE the_dates_table AS (
  SELECT DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours'))::DATE AS the_index_date --today's start date
);


--DELETE THE DATA FOR THE DAY YOU ARE GOING TO BE ADDING IN
PREPARE the_delete_function_helper_daily_hours_watched_per_channel_platform_game (BIGINT) AS
DELETE FROM dx_sandbox.extension_cme_metric_helper_daily_hours_watched_per_channel_platform_game
WHERE the_day = DATEADD(  day, $1, (SELECT the_index_date FROM the_dates_table)  )
;


--THEN CREATE A the_temp_table BASED ON THAT SCHEMA
CREATE TEMP TABLE the_temp_table (LIKE dx_sandbox.extension_cme_metric_helper_daily_hours_watched_per_channel_platform_game);

--THEN WRITE YOUR SQL CODE FOR THE INSERT FUNCTION
PREPARE the_insert_function_helper_daily_hours_watched_per_channel_platform_game (BIGINT) AS
INSERT INTO the_temp_table (

  WITH

  the_parameter_input AS (
    SELECT DATEADD(  day, $1, (SELECT the_index_date FROM the_dates_table)  ) AS the_day_to_refresh_data_for
  )

  , the_constants_time AS (
    SELECT start_date, DATEADD(day, 1, start_date) AS end_date
    FROM (SELECT the_day_to_refresh_data_for AS start_date FROM the_parameter_input)
  )

  , daily_hours_watched_per_channel_platform_game AS (
    SELECT day AS the_day, channel_id, platform
      , regexp_replace(lower(game),'([^a-zA-Z0-9.])','') as game_flattened --anything that isn't alphanumeric replace with blank
      , SUM(mw::FLOAT/60) AS hw
    FROM cubes.hours_watched_daily_by_device
    WHERE
      (SELECT start_date FROM the_constants_time)<=day AND day<(SELECT end_date FROM the_constants_time)
      AND content_mode IN ('live stream')
    GROUP BY 1,2,3,4
  )

  , channel_daily_status AS (
    SELECT the_date, channel_id, tier
    FROM dx_rollup.channel_daily_status
    WHERE
      (SELECT start_date FROM the_constants_time)<=the_date AND the_date<(SELECT end_date FROM the_constants_time)
  )

  , final_data AS (
    SELECT base.the_day, base.channel_id, base.platform::VARCHAR(255), base.game_flattened::VARCHAR(MAX)
      , CASE WHEN cds.tier IN ('T5: Premium') THEN 'O&O Channel' ELSE 'UGC Channel' END AS flag_ugc_oo_channel
      -- , cds.flag_ugc_oo_channel::VARCHAR(32)
      , base.hw
    FROM daily_hours_watched_per_channel_platform_game AS base
    LEFT JOIN channel_daily_status AS cds ON base.channel_id = cds.channel_id AND base.the_day = cds.the_date
  )

  SELECT * FROM final_data

);




EXECUTE the_insert_function_helper_daily_hours_watched_per_channel_platform_game (-3);
EXECUTE the_delete_function_helper_daily_hours_watched_per_channel_platform_game (-3);
INSERT INTO dx_sandbox.extension_cme_metric_helper_daily_hours_watched_per_channel_platform_game    (SELECT * FROM the_temp_table);
DELETE FROM the_temp_table;

EXECUTE the_insert_function_helper_daily_hours_watched_per_channel_platform_game (-2);
EXECUTE the_delete_function_helper_daily_hours_watched_per_channel_platform_game (-2);
INSERT INTO dx_sandbox.extension_cme_metric_helper_daily_hours_watched_per_channel_platform_game    (SELECT * FROM the_temp_table);
DELETE FROM the_temp_table;


EXECUTE the_insert_function_helper_daily_hours_watched_per_channel_platform_game (-1);
EXECUTE the_delete_function_helper_daily_hours_watched_per_channel_platform_game (-1);
INSERT INTO dx_sandbox.extension_cme_metric_helper_daily_hours_watched_per_channel_platform_game    (SELECT * FROM the_temp_table);
DELETE FROM the_temp_table;

