-- SCHEMA
-- the_day	timestamp
-- channel_id	bigint
-- the_extension_id_array varchar(max)
-- the_extension_name_array varchar(max)
-- the_game	varchar(255)
-- platform	varchar(255)
-- flag_ugc_oo_channel	varchar(255)
-- hw_with_blessed_extension	double precision
-- total_hw	double precision
-- pct_hw_with_blessed_extension	double precision




-- CHANGE the_index_date IF YOU WANT TO CHANGE THE RELATIVE DATE
CREATE TEMP TABLE the_dates_table AS (
  SELECT DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours'))::DATE AS the_index_date --today's start date
);

--DELETE THE DATA FOR THE DAY YOU ARE GOING TO BE ADDING IN
PREPARE the_delete_function_extension_content_matched_metric_partial_ugc (BIGINT) AS
DELETE FROM dx_sandbox.extension_content_matched_metric_partial_ugc
WHERE the_day = DATEADD(  day, $1, (SELECT the_index_date FROM the_dates_table)  )
;






--THEN CREATE A the_temp_table BASED ON THAT SCHEMA
CREATE TEMP TABLE the_temp_table (LIKE dx_sandbox.extension_content_matched_metric_partial_ugc);

--THEN WRITE YOUR SQL CODE FOR THE INSERT FUNCTION
PREPARE the_insert_function_extension_content_matched_metric_partial_ugc (BIGINT) AS
INSERT INTO the_temp_table (


  WITH

  the_parameter_input AS (
    SELECT DATEADD(  day, $1, (SELECT the_index_date FROM the_dates_table)  ) AS the_day_to_refresh_data_for
  )

  , the_constants_time AS (
    SELECT start_date, DATEADD(day, 1, start_date) AS end_date
    FROM (SELECT the_day_to_refresh_data_for AS start_date FROM the_parameter_input)
  )

  , the_constants_param AS (
    SELECT 'UGC Channel'::VARCHAR(255) AS flag_ugc_oo_channel
  )







  , daily_hours_watched_per_channel_platform_game AS (
    SELECT the_day, channel_id, platform, game_flattened, flag_ugc_oo_channel, hw
    FROM dx_sandbox.extension_cme_metric_helper_daily_hours_watched_per_channel_platform_game
    WHERE
      (SELECT start_date FROM the_constants_time)<=the_day AND the_day<(SELECT end_date FROM the_constants_time)
      AND flag_ugc_oo_channel = (SELECT flag_ugc_oo_channel FROM the_constants_param) -- it is a premium channel
  )


  --ASSUME THAT IF AN O&O CHANNEL HAS THE BLESSED EXTENSION ACTIVE, THEN COUNT IT AS HW WITH EXTENSION (i.e. TWITCH PRESENTS CHANNEL WILL CORRECTLY TURN OFF POKEMON EXTENSION WHEN NOT STREAMING POKEMON)
  , joined_daily_blessed_hours_watched_ugc AS (
    SELECT
      base.the_day, base.channel_id, base.flag_ugc_oo_channel, base.platform, base.game_flattened
      , the_extension_id_array, the_extension_name_array
      -----------------------------------------------------------------------
      --ADJUST THIS WHEN OTHER PLATFORMS GET EXTENSION SUPPORT (i.e. CONSOLE)
      -----------------------------------------------------------------------
      , CASE
        WHEN base.flag_ugc_oo_channel='UGC Channel' AND blessed.flag_is_ugc_content_matched_extension AND base.platform='web' AND flag_count_web THEN TRUE
        WHEN base.flag_ugc_oo_channel='UGC Channel' AND blessed.flag_is_ugc_content_matched_extension AND base.platform='android' AND flag_count_android THEN TRUE
        WHEN base.flag_ugc_oo_channel='UGC Channel' AND blessed.flag_is_ugc_content_matched_extension AND base.platform='ios' AND flag_count_ios THEN TRUE
        WHEN base.flag_ugc_oo_channel='UGC Channel' AND blessed.flag_is_ugc_content_matched_extension AND base.platform='desktop' AND flag_count_desktop THEN TRUE
        WHEN base.flag_ugc_oo_channel='O&O Channel' AND blessed.flag_is_premium_content_matched_extension AND base.platform='web' AND flag_count_web THEN TRUE
        WHEN base.flag_ugc_oo_channel='O&O Channel' AND blessed.flag_is_premium_content_matched_extension AND base.platform='android' AND flag_count_android THEN TRUE
        WHEN base.flag_ugc_oo_channel='O&O Channel' AND blessed.flag_is_premium_content_matched_extension AND base.platform='ios' AND flag_count_ios THEN TRUE
        WHEN base.flag_ugc_oo_channel='O&O Channel' AND blessed.flag_is_premium_content_matched_extension AND base.platform='desktop' AND flag_count_desktop THEN TRUE
      ELSE FALSE END AS flag_mw_with_blessed_extension
      -----------------------------------------------------------------------
      -----------------------------------------------------------------------
      , base.hw
    FROM daily_hours_watched_per_channel_platform_game AS base
    LEFT JOIN dx_sandbox.extension_cme_metric_helper_daily_blessed_extension_per_channel AS blessed
      ON base.the_day = blessed.the_day
      AND base.channel_id = blessed.channel_id
      AND base.game_flattened = blessed.game_flattened
  )


  , final_data_ugc AS (
    SELECT
      the_day, channel_id, platform, flag_ugc_oo_channel, game_flattened
      , the_extension_id_array, the_extension_name_array
      , ROUND(hw_with_blessed_extension::FLOAT,2) AS hw_with_blessed_extension
      , ROUND(total_hw::FLOAT,2) AS total_hw
      , ROUND(pct_hw_with_blessed_extension::FLOAT,6) AS pct_hw_with_blessed_extension
    FROM (
      SELECT
        the_day, channel_id, platform, flag_ugc_oo_channel, game_flattened
        , the_extension_id_array, the_extension_name_array
        , SUM(CASE WHEN flag_mw_with_blessed_extension THEN hw ELSE 0 END) AS hw_with_blessed_extension
        , SUM(hw) AS total_hw
        , SUM(CASE WHEN flag_mw_with_blessed_extension THEN hw ELSE 0 END)::FLOAT/NULLIF(SUM(hw::FLOAT),0) AS pct_hw_with_blessed_extension
      FROM joined_daily_blessed_hours_watched_ugc
      GROUP BY 1,2,3,4,5,6,7
    )
  )


  , final_data AS (
    SELECT * FROM final_data_ugc
  )


  SELECT * FROM final_data




);



EXECUTE the_insert_function_extension_content_matched_metric_partial_ugc (-3);
EXECUTE the_delete_function_extension_content_matched_metric_partial_ugc (-3);
INSERT INTO dx_sandbox.extension_content_matched_metric_partial_ugc    (SELECT * FROM the_temp_table);
DELETE FROM the_temp_table;

EXECUTE the_insert_function_extension_content_matched_metric_partial_ugc (-2);
EXECUTE the_delete_function_extension_content_matched_metric_partial_ugc (-2);
INSERT INTO dx_sandbox.extension_content_matched_metric_partial_ugc    (SELECT * FROM the_temp_table);
DELETE FROM the_temp_table;


EXECUTE the_insert_function_extension_content_matched_metric_partial_ugc (-1);
EXECUTE the_delete_function_extension_content_matched_metric_partial_ugc (-1);
INSERT INTO dx_sandbox.extension_content_matched_metric_partial_ugc    (SELECT * FROM the_temp_table);
DELETE FROM the_temp_table;










DROP TABLE the_temp_table;
DEALLOCATE the_insert_function_extension_content_matched_metric_partial_ugc;
DEALLOCATE the_delete_function_extension_content_matched_metric_partial_ugc;

