CREATE TABLE IF NOT EXISTS dx_sandbox.daily_web_extension_viewer_funnel_helper_channel_presence (
  the_day                                 TIMESTAMP WITHOUT TIME ZONE sortkey
  , extension_id                          VARCHAR(32)
  , channel_id                            BIGINT
  , extension_anchor                      VARCHAR(32)
  , bool_extension_activated              BOOLEAN
);

CREATE TEMP TABLE temp_table (LIKE dx_sandbox.daily_web_extension_viewer_funnel_helper_channel_presence);

PREPARE the_insert_function_daily_web_extension_viewer_funnel_helper_channel_presence (BIGINT) as
INSERT INTO temp_table (
  WITH the_parameter_constants AS (
    SELECT
      DATEADD(day, $1, DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours'))) as start_day,
      DATEADD(day, $1, DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours'))) + interval '1 day' as end_day
  )

  SELECT DISTINCT
    the_day,
    extension_id,
    channel_id,
    extension_anchor ,
    bool_extension_activated
  FROM dx_rollup.extension_daily_channel_presence a
  JOIN the_parameter_constants b
    ON a.the_day >= b.start_day and a.the_day < b.end_day
  WHERE
    bool_extension_activated = TRUE
);

PREPARE the_delete_function_daily_web_extension_viewer_funnel_helper_channel_presence (BIGINT) AS
DELETE FROM dx_sandbox.daily_web_extension_viewer_funnel_helper_channel_presence
WHERE the_day = DATEADD(day, $1, DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours')));

---
EXECUTE the_delete_function_daily_web_extension_viewer_funnel_helper_channel_presence(-2);
EXECUTE the_insert_function_daily_web_extension_viewer_funnel_helper_channel_presence(-2);
INSERT INTO dx_sandbox.daily_web_extension_viewer_funnel_helper_channel_presence
  (SELECT * FROM temp_table);
DELETE FROM temp_table;


EXECUTE the_delete_function_daily_web_extension_viewer_funnel_helper_channel_presence(-1);
EXECUTE the_insert_function_daily_web_extension_viewer_funnel_helper_channel_presence(-1);
INSERT INTO dx_sandbox.daily_web_extension_viewer_funnel_helper_channel_presence
  (SELECT * FROM temp_table);
DELETE FROM temp_table;

DEALLOCATE the_insert_function_daily_web_extension_viewer_funnel_helper_channel_presence;
DEALLOCATE the_delete_function_daily_web_extension_viewer_funnel_helper_channel_presence;
