CREATE TABLE IF NOT EXISTS dx_rollup.creator_stream_session (
  the_day                     TIMESTAMP WITHOUT TIME ZONE sortkey
  , broadcast_id              BIGINT
  , channel_id                BIGINT
  , channel                   VARCHAR(65535)
  , country                   VARCHAR(2)
  , language                  VARCHAR(5)
  , platform                  VARCHAR(16)
  -- , title_of_stream
  , game                      VARCHAR(128)
  , stream_start_time         TIMESTAMP WITHOUT TIME ZONE
  , stream_end_time           TIMESTAMP WITHOUT TIME ZONE
  , broadcast_length_mins     INTEGER
  , broadcast_length_hrs      FLOAT
);

CREATE TEMP TABLE temp_table (LIKE dx_rollup.creator_stream_session);

PREPARE the_delete_function (BIGINT) AS
DELETE FROM dx_rollup.creator_stream_session
WHERE the_day = DATEADD(day, $1, DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours')));


PREPARE the_insert_function (BIGINT) AS
INSERT INTO temp_table (

with the_parameter_constants as (
  SELECT
  DATEADD(day, $1, DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours'))) as start_day,
  DATEADD(day, 1, DATEADD(day, $1, DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours')))) as end_day
)

, minute_broadcast_flagged as (
  SELECT
  base.channel_id,
  "time",
  broadcast_id,
  game,
  platform,
  language,
  country,
  CASE WHEN
    -- first value
    time = first_value(time) over (partition by base.channel_id, broadcast_id, game order by "time" rows between unbounded preceding and unbounded following)
      or
    -- game changes
    game != lag(game) OVER (PARTITION by base.channel_id, broadcast_id ORDER BY "time")
      or
    -- broadcast_id changes
    broadcast_id != lag(broadcast_id) OVER (PARTITION by base.channel_id ORDER BY "time")
  THEN 'start_time'

  when
    time = first_value(time) over (partition by base.channel_id, broadcast_id, game order by "time" desc rows between unbounded preceding and unbounded following)
      or
    game != lag(game) OVER (PARTITION by base.channel_id, broadcast_id ORDER BY "time" desc)
      or broadcast_id != lag(broadcast_id) OVER (PARTITION by base.channel_id ORDER BY "time" desc)
  THEN 'end_time'

  else 'continuation' END AS flag

  from spade.minute_broadcast base
  left join cubes.daily_channel_broadcast_time_ranges dcbtr -- to make sure broadcast type is LIVE, not VODCAST
    on base.channel_id = dcbtr.channel_id
    and date = dcbtr.day
    and "time" >= start_time_inclusive
    and "time" < end_time_exclusive

  where date >= (select start_day from the_parameter_constants)
  and date < (select end_day from the_parameter_constants)
  and base.channel_id is not NULL
  and game is not null
  and broadcast_type = 'live'
)

SELECT DISTINCT
  DATE_TRUNC('day', a.time) as the_day,
  a.broadcast_id,
  a.channel_id,
  users.login as channel,
  a.country,
  a.language,
  a.platform,
  a.game,
  a.time as stream_start_time
  , first_value(b.time) over (partition by a.broadcast_id, a.channel_id, a.game, a.time
    order by b.time rows between unbounded preceding and unbounded following)
    as stream_end_time
  , DATEDIFF(minute, stream_start_time, stream_end_time) as broadcast_length_mins
  , ROUND((DATEDIFF(minute, stream_start_time, stream_end_time)::FLOAT/60),2) as broadcast_length_hrs

  FROM (select * from minute_broadcast_flagged where flag = 'start_time') as a -- get start times
  INNER JOIN (select * from minute_broadcast_flagged where flag = 'end_time') as b -- get end times and join with corresponding start times
    on a.broadcast_id = b.broadcast_id
    and a.game = b.game
    and a.channel_id = b.channel_id
    and b.time >= a.time

  LEFT JOIN dbsnapshots.users as users
    on users.id = a.channel_id

);

--EXECUTE the_delete_function(-2);
--EXECUTE the_insert_function(-2);
--INSERT INTO dx_rollup.creator_stream_session
--  (SELECT * FROM temp_table);
--DELETE FROM temp_table;

EXECUTE the_delete_function(-1);
EXECUTE the_insert_function(-1);
INSERT INTO dx_rollup.creator_stream_session
  (SELECT * FROM temp_table);
DELETE FROM temp_table;

DEALLOCATE the_delete_function;
DEALLOCATE the_insert_function;
