--DROP TABLE IF EXISTS dx_rollup.dynamic_management_enabled_sessions;

--CREATE TABLE IF NOT EXISTS dx_rollup.dynamic_management_enabled_sessions (
--the_day                                DATE sortkey
--,channel_id                            BIGINT distkey
--,extension_id                          VARCHAR(32)
--,game_flattened                        VARCHAR(1000)
--,start_time                            TIMESTAMP WITHOUT TIME ZONE
--,end_time                              TIMESTAMP WITHOUT TIME ZONE
--);

DELETE FROM dx_rollup.dynamic_management_enabled_sessions;


CREATE TEMP TABLE the_temp_table (LIKE dx_rollup.dynamic_management_enabled_sessions);

PREPARE the_insert_function (VARCHAR) AS
INSERT INTO the_temp_table(

  -- get the day to insert
  WITH
  the_parameter_constants AS (
    SELECT
    $1::timestamp as start_day
  ),

  logs as (
    select "time", channel_id, extension_id, game_flattened, event,
     CASE WHEN
        --first value
        time = first_value(time) over (partition by channel_id, extension_id order by channel_id, extension_id, "time" rows between unbounded preceding and unbounded following)
        and event = 'dynamic_management_enable'
        then 'start_time'
        WHEN
        -- event changes
        (event != lag(event) OVER (PARTITION by channel_id, extension_id ORDER BY channel_id, extension_id,"time") and event = 'dynamic_management_disable') THEN 'end_time'
        WHEN
         (event != lag(event) OVER (PARTITION by channel_id, extension_id ORDER BY channel_id, extension_id,"time") and event = 'dynamic_management_enable') THEN 'start_time'
      when
      time = first_value(time) over (partition by channel_id, extension_id, event order by channel_id, extension_id,"time" desc rows between unbounded preceding and unbounded following)
      and event = 'dynamic_management_disable'
     THEN 'end_time'
    else 'continuation'
    END AS flag
    from dx_rollup.dynamic_management_enables_and_disables
    where "time" >= (select start_day from the_parameter_constants)
    order by 2,3,1
  ),
  dm_enabled_sessions as (
      select distinct
      a.channel_id,
      a.extension_id,
      a.game_flattened,
      a.time as start_time,
      first_value(b.time) over (partition by  a.channel_id, a.extension_id, a.time
        order by b.channel_id, b.extension_id, b.time rows between unbounded preceding and unbounded following)
      as end_time
      --first_value(b.time) over (partition by  a.channel_id, a.extension_id, a.time
      --order by b.channel_id, b.extension_id, b.time rows between unbounded preceding and unbounded following) as end_time
      from (select * from logs where flag = 'start_time') as a
      left join (select * from logs where flag = 'end_time') as b
        on a.channel_id = b.channel_id
        and a.extension_id = b.extension_id
        and b.time >= a.time

)

select start_time::date as the_day,
channel_id,
extension_id,
game_flattened,
start_time,
end_time
from dm_enabled_sessions
);

--RUN THE INSERT FUNCTIONS


EXECUTE the_insert_function('2019-08-20');


-- Load TEMP_TABLE into TABLE AFTER DELETING THE DATA
INSERT INTO dx_rollup.dynamic_management_enabled_sessions
(SELECT * FROM the_temp_table);

-- DEALLOCATE THE INSERT FUNCTION
DEALLOCATE the_insert_function;

