-- tahoe.extension_create, tahoe.extension_lifecycle

--------------------------------------------------------------------------------------------
-- Legacy lookup table we migrated from ace to support insights product's reporting needs --
--------------------------------------------------------------------------------------------

DELETE FROM dx_sandbox.extension_creator_lookup;


INSERT INTO dx_sandbox.extension_creator_lookup (
  WITH
  logs1 AS (
     SELECT extension_id, user_id
     FROM tahoe.extension_create
     WHERE state IN ('Testing')
     GROUP BY 1,2
   )
   , logs2 AS (
     SELECT extension_id, user_id
     FROM tahoe.extension_lifecycle
     WHERE state IN ('Testing')
     GROUP BY 1,2
   )
   , logs_final AS (
     SELECT extension_id, user_id
     FROM (
       SELECT * FROM logs1
       UNION SELECT * FROM logs2
     ) as logs_all
     GROUP BY 1,2
   )
   , final AS (
     SELECT base.*, rel.extension_name, rel.extension_url
     FROM logs_final AS base
     JOIN dx_metadata.released_extensions_latest AS rel ON base.extension_id = rel.extension_id
   )
   SELECT final.extension_id,final.user_id, su.login, final.extension_name, final.extension_url
   FROM final
   LEFT JOIN dbsnapshots.users AS su ON final.user_id = su.id
);

