
-- This table is a rollup on top of the extensions_active_per_minute_watched event
-- This rollup adds extension_id, extension_anchor, extension_slot and host_channel_id
-- Currently this table is missing hosted panel extension minutes - there are no panels for hosted minutes
-- hosting example: host: 32452196 guest:28575692 -- many data inconsistencies



-- the delete function
PREPARE the_delete_function (BIGINT) AS
DELETE FROM dx_rollup.extension_minute_watched_rollup
WHERE dx_rollup.extension_minute_watched_rollup.day = DATEADD(day, $1, DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours')));



--THEN CREATE A the_temp_table BASED ON THAT SCHEMA
CREATE TEMP TABLE the_temp_table (LIKE dx_rollup.extension_minute_watched_rollup);

PREPARE the_insert_function (BIGINT) AS
INSERT INTO the_temp_table (


with

seq as (
  select n::int as i
  from dx_metadata.number_series
  where n >= 0 and n < 10
)


, the_dates as (
      SELECT DATEADD(day, $1, DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours'))) as day
)

-- get extensions minutes watched for the day

, ext_mw as (
  select
  "time" as the_time,
  date as day,
  channel_id ,
  play_session_id,
  user_id,
  device_id,
  game, -- flatten
  f_get_platform(platform) as platform,
  f_get_content_mode(broadcaster_software, vod_type, content_mode, live) as content_mode,
  is_valid_json_array(active_extensions) as json_flag,
  staff,
  client_app,
  country,
  player,
  broadcast_id,
  content,
  medium,
  referrer_url,
  url,
  active_extensions
  from spade.extensions_active_per_minute_watched
  where date = (select day from the_dates)
)

-- exploding the json array for active extensions

, ext_mw_exploded as (
  select a.*, json_extract_array_element_text(a.active_extensions, seq.i) as json
  from ext_mw as a , seq
  where seq.i < json_array_length(a.active_extensions)
  and a.content_mode = 'live stream'
  and a.json_flag
  and (player not in ('frontpage','home') or player is null)
)

-- all extensions minutes watched with extension_id, extension_anchor and extension_slot

, ext_mw_final as (
  select
  the_time,
  day,
  channel_id ,
  play_session_id,
  user_id,
  device_id,
  game,
  LOWER(REGEXP_REPLACE(game,'[^a-zA-Z0-9]','')) AS game_flattened,
  platform,
  json_extract_path_text(json, 'extension_id', true) as extension_id,
  json_extract_path_text(json, 'extension_anchor', true) as extension_anchor,
  json_extract_path_text(json, 'extension_slot', true) as extension_slot,
  content_mode,
  staff,
  client_app,
  country,
  player,
  broadcast_id,
  content,
  medium,
  referrer_url,
  url
  from ext_mw_exploded
)

-- get the hosted extensions minutes through host channel id from all mw

, host_ext_mw as (
  select a.*, b.host_channel_id
  from ext_mw_final as a
  join spade."minute-watched" as b
  on a.the_time = b.time
  and a.channel_id = b.channel_id
  and a.device_id = b.device_id
  and a.play_session_id = b.play_session_id
  where b.host_channel_id is not null
  and b.date = (select day from the_dates)
)

-- get the extension minutes that were not hosted

, non_host_ext_mw as (
  select * , null as host_channel_id from ext_mw_final
  except
  select * from host_ext_mw
)

-- combine both hosted and non hosted extension minutes watched
-- remove all rows with panel extensions for hosted extension minutes watched since
-- those should be the panels of the channel hosting (host_channel_id) and not of the channel being hosted (channel_id).
-- To add the panel extension mw for the channel hosting after checking for host channel id data quality
-- Therefore currently this data is missing hosted panel extension minutes

, final as (
  select * from non_host_ext_mw
  union
  select * from host_ext_mw
  where extension_anchor != 'panel'
)

select * from final

);


-- run the delete and insert functions
EXECUTE the_delete_function (-1);
EXECUTE the_insert_function(-1);
INSERT INTO dx_rollup.extension_minute_watched_rollup
(SELECT * FROM the_temp_table);
DELETE FROM the_temp_table;



-- deallocate the insert and delete functions
DEALLOCATE the_insert_function;
DEALLOCATE the_delete_function;


