-- CREATE TABLE IF NOT EXISTS dx_sandbox.daily_web_extension_viewer_funnel_helper_render_view_log (
--   dt                                          TIMESTAMP WITHOUT TIME ZONE sortkey
--   , extension_id                              VARCHAR(32)
--   , action                                    VARCHAR(6)
--   , unique_devices_web                        BIGINT
--   , unique_devices_web_video                  BIGINT
--   , unique_devices_web_component              BIGINT
--   , unique_devices_web_panel                  BIGINT
-- );

CREATE TEMP TABLE temp_table (LIKE dx_rollup.extension_web_viewer_funnel_daily);

PREPARE the_delete_function_daily_web_extension_viewer_funnel_final (BIGINT) AS
DELETE FROM dx_rollup.extension_web_viewer_funnel_daily
WHERE the_day = DATEADD(day, $1, DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours')));

PREPARE the_insert_function_daily_web_extension_viewer_funnel_final (BIGINT) AS
INSERT INTO temp_table (
  WITH the_parameter_constants AS (
    SELECT
      DATEADD(day, $1, DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours'))) as start_day,
      DATEADD(day, $1, DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours'))) + interval '1 day' as end_day
  )

  SELECT * FROM dx_sandbox.daily_web_extension_viewer_funnel_helper_render_view_log
    WHERE dt = (SELECT start_day FROM the_parameter_constants)
  UNION
  SELECT * FROM dx_sandbox.daily_web_extension_viewer_funnel_helper_click_log
    WHERE dt = (SELECT start_day FROM the_parameter_constants)
);

----
EXECUTE the_delete_function_daily_web_extension_viewer_funnel_final(-2);
EXECUTE the_insert_function_daily_web_extension_viewer_funnel_final(-2);
INSERT INTO dx_rollup.extension_web_viewer_funnel_daily
  (SELECT * FROM temp_table);
DELETE FROM temp_table;

EXECUTE the_delete_function_daily_web_extension_viewer_funnel_final(-1);
EXECUTE the_insert_function_daily_web_extension_viewer_funnel_final(-1);
INSERT INTO dx_rollup.extension_web_viewer_funnel_daily
  (SELECT * FROM temp_table);
DELETE FROM temp_table;


----------------------------------------------------------------------------------
 -- REMOVE DATA FROM dx_sandbox tables that were used to build this final rollup --
----------------------------------------------------------------------------------
DELETE FROM dx_sandbox.daily_web_extension_viewer_funnel_helper_render_view_log;
DELETE FROM dx_sandbox.daily_web_extension_viewer_funnel_helper_click_log;
DELETE FROM dx_sandbox.daily_web_extension_viewer_funnel_helper_click;
DELETE FROM dx_sandbox.daily_web_extension_viewer_funnel_helper_view;
DELETE FROM dx_sandbox.daily_web_extension_viewer_funnel_helper_render;
DELETE FROM dx_sandbox.daily_web_extension_viewer_funnel_helper_view_log;
DELETE FROM dx_sandbox.daily_web_extension_viewer_funnel_helper_render_log;
DELETE FROM dx_sandbox.daily_web_extension_viewer_funnel_helper_channel_presence;

DEALLOCATE the_delete_function_daily_web_extension_viewer_funnel_final;
DEALLOCATE the_insert_function_daily_web_extension_viewer_funnel_final;
