-- return twitch user_id and the type of drops action completed
--DATA ERRORS?? configure_drops_settings occurs before create_drops_process_start?

--         time         |  user_id  |           action
-- ---------------------+-----------+----------------------------
--  2017-10-10 10:49:18 |  64637044 | configure_drops_settings
--  2017-10-10 10:49:28 |  64637044 | create_drops_process_start
--  2017-10-11 13:43:56 | 122859157 | configure_drops_settings
--  2017-10-10 10:14:27 | 127516441 | create_drops_process_start
--  2017-10-10 10:26:48 | 147118718 | create_drops_process_start
--  2017-10-11 07:49:32 | 147118718 | configure_drops_settings
--  2017-10-09 15:07:03 | 175133161 | configure_drops_settings
--  2017-10-09 15:07:15 | 175133161 | create_drops_process_start

WITH
action_start_drops AS (
SELECT MIN(time) AS "time", user_id, 'create_drops_process_start' AS action
FROM logs.cobalt_button_click
WHERE url LIKE '%dev.twitch.tv%'
AND label='Create Drops Process Start'
AND time>='2017-08-01 00:00:00'
GROUP BY user_id
)

, action_configure_drops AS (
SELECT MIN(time) AS "time", user_id, 'configure_drops_settings' AS action
FROM logs.cobalt_button_click
WHERE url LIKE '%dev.twitch.tv%'
AND label='Configure Drops Settings'
AND time>='2017-08-01 00:00:00'
GROUP BY user_id
)

, action_complete_drops AS (
SELECT MIN(time) AS "time", user_id, 'create_drops_process_complete' AS action
FROM logs.cobalt_button_click
WHERE url LIKE '%dev.twitch.tv%'
AND label='Create Drops Process Complete'
AND time>='2017-08-01 00:00:00'
GROUP BY user_id
)

SELECT * FROM action_start_drops
UNION ALL SELECT * FROM action_configure_drops
UNION ALL SELECT * FROM action_complete_drops
ORDER BY user_id, "time"
