-- return twitch user_id and the type of game mgmt action completed

WITH
action_register_game AS (
SELECT MIN(time) AS "time", user_id, 'registered_game' AS action
FROM logs.cobalt_button_click
WHERE url LIKE '%dev.twitch.tv%'
AND label='Registered Game'
AND time>='2017-08-01 00:00:00'
GROUP BY user_id
)

, action_upload_box_art AS (
SELECT MIN(time) AS "time", user_id, 'uploaded_box_art' AS action
FROM logs.cobalt_button_click
WHERE url LIKE '%dev.twitch.tv%'
AND label='Uploaded Box Art'
AND time>='2017-08-01 00:00:00'
GROUP BY user_id
)

SELECT * FROM action_register_game
UNION ALL SELECT * FROM action_upload_box_art
ORDER BY user_id, "time"
