
DROP TABLE IF EXISTS dx_sandbox.edcp_helper_all_activate_records_parsed_final;

CREATE TABLE dx_sandbox.edcp_helper_all_activate_records_parsed_final AS



WITH

the_json AS (
  SELECT id::BIGINT AS channel_id, slots
  FROM dbsnapshots.extensions_channel_extensions
  WHERE
    slots IS NOT NULL
    AND id IS NOT NULL
    AND f_is_numeric(id) = TRUE  -- for some reason the id field is not all integer...
)



, the_json_component AS (
  SELECT channel_id
    , json_extract_path_text(slots,'component') AS active_extensions_array
  FROM the_json
)
, the_json_video_overlay AS (
  SELECT channel_id
    , json_extract_path_text(slots,'video_overlay') AS active_extensions_array
  FROM the_json
)
, the_json_video_panel AS (
  SELECT channel_id
    , json_extract_path_text(slots,'panel') AS active_extensions_array
  FROM the_json
)

, the_json_active_extensions AS (
  SELECT *
  FROM (
    SELECT * FROM the_json_component
    UNION SELECT * FROM the_json_video_overlay
    UNION SELECT * FROM the_json_video_panel
  )
  WHERE active_extensions_array IS NOT NULL
)



, seq AS (
  SELECT n AS i
  FROM dx_metadata.number_series
  WHERE n>=0 AND n<=10
)

, expanded_json AS (
  SELECT channel_id, JSON_EXTRACT_ARRAY_ELEMENT_TEXT(active_extensions_array, seq.i) AS active_extension_json
  FROM the_json_active_extensions, seq
  WHERE seq.i < JSON_ARRAY_LENGTH(active_extensions_array)
)

, final_data AS (
  SELECT channel_id
    , split_part(extension_id,'!',1) as extension_id -- there is some weird thing where it ends with exclamation mark !
    , extension_anchor, extension_slot
  FROM (
    SELECT channel_id
      , json_extract_path_text(active_extension_json, 'Key') AS extension_id
      , json_extract_path_text(active_extension_json, 'Type') AS extension_anchor
      , json_extract_path_text(active_extension_json, 'SlotName') AS extension_slot
    FROM expanded_json
  )
)

SELECT * FROM final_data
;
