
DROP TABLE IF EXISTS dx_sandbox.edcp_helper_all_install_records_parsed_part1;

CREATE TABLE dx_sandbox.edcp_helper_all_install_records_parsed_part1 AS

WITH

the_logs AS (
  SELECT id::BIGINT AS channel_id, installs AS installs_json
  FROM dbsnapshots.extensions_channel_extensions
  WHERE
    installs IS NOT NULL
    AND id IS NOT NULL
    AND f_is_numeric(id) = TRUE
)


--used to get the maximum number of install records for all channels
, install_per_channel AS (
  SELECT channel_id, REGEXP_COUNT(installs_json, '[0-9a-z.]+!')::BIGINT AS install_record  --- UPDATE REGEX STRING MANUALLY HERE CANNOT USE CTE ---
  FROM the_logs
)


SELECT * FROM install_per_channel;
