-- NOTE: search for the following string if you need to update the regex logic
-- this is because the regex functions in redshift only allow string literals
-- and you can't select a string from a CTE
-- the string to search --->          --- UPDATE REGEX STRING MANUALLY HERE CANNOT USE CTE ---


DROP TABLE IF EXISTS dx_sandbox.edcp_helper_all_install_records_parsed_part1;

CREATE TABLE dx_sandbox.edcp_helper_all_install_records_parsed_part1 AS


-- SELECT * FROM dbsnapshots.extensions_channel_extensions WHERE
-- f_is_numeric(id) = FALSE
-- id LIKE '%RIG173220974%' OR id IS NULL
-- OR  id LIKE '%u%'

WITH

the_logs AS (
  SELECT id::BIGINT AS channel_id, installs AS installs_json
  FROM dbsnapshots.extensions_channel_extensions
  WHERE
    installs IS NOT NULL
    AND id IS NOT NULL
    AND f_is_numeric(id) = TRUE
)

, extension_life_cycle_compress AS (
  SELECT extension_id, TRUE AS flag_is_deleted
  FROM dx_sandbox.extensions_metadata_helper_lifecycle_log
  WHERE extension_state IN ('Deleted')
  GROUP BY 1
)

-- previous versions of OP.gg league of legends extension was deleted, but it is still a "released" extension
-- https://www.twitch.tv/ext/lgpf9j7y8n1ja9onkb6w7bxfkhk2zl
, deleted_extensions_list AS (
  SELECT * FROM extension_life_cycle_compress
  WHERE extension_id NOT IN (SELECT extension_id FROM dx_metadata.released_extensions_latest)
)

--used to get the maximum number of install records for all channels
, install_per_channel AS (
  SELECT channel_id, REGEXP_COUNT(installs_json, '[0-9a-z.]+!')::BIGINT AS install_record  --- UPDATE REGEX STRING MANUALLY HERE CANNOT USE CTE ---
  FROM the_logs
)

, smaller_number_series AS (
  SELECT n
  FROM dx_metadata.number_series
  WHERE n>=1 AND n<=(SELECT MAX(install_record) FROM install_per_channel)
)

, cross_join_logs_number_series AS (
  SELECT channel_id, installs_json, n
  FROM the_logs
  CROSS JOIN smaller_number_series
)

SELECT * FROM cross_join_logs_number_series;

, trim_cross_join_logs_number_series AS (
  SELECT *
  FROM (
    SELECT base.channel_id, base.installs_json, base.n, install.install_record
    FROM cross_join_logs_number_series AS base
    LEFT JOIN install_per_channel AS install ON base.channel_id = install.channel_id
  )
  WHERE n>=1 AND n<=install_record
)

SELECT MIN(n), MAX(n), SUM(1) FROM trim_cross_join_logs_number_series


-- product-> SELECT MIN(n), MAX(n), SUM(1) FROM cross_join_logs_number_series;
--  min | max |    sum
-- -----+-----+------------
--    1 | 396 | 1771800624

, install_extensions_logs AS (
  SELECT
    channel_id
    , RTRIM(REGEXP_SUBSTR(installs_json, '[0-9a-z.]+!', 1, num.n), '!') as extension_id --- UPDATE REGEX STRING MANUALLY HERE CANNOT USE CTE ---
  FROM the_logs, dx_metadata.number_series AS num
  WHERE num.n >= 1 AND num.n <= REGEXP_COUNT(installs_json, '[0-9a-z.]+!')  --- UPDATE REGEX STRING MANUALLY HERE CANNOT USE CTE ---
)

, install_extensions_list AS (
  SELECT a.*, TRUE AS bool_extension_installed
  FROM install_extensions_logs AS a
  LEFT JOIN deleted_extensions_list AS b ON a.extension_id = b.extension_id
  WHERE flag_is_deleted IS NULL OR flag_is_deleted = FALSE
)


SELECT * FROM install_extensions_list;
