--started some data processing from the mode report
--   https://modeanalytics.com/editor/twitch/reports/43ed26fbf8e6

-- used insert function helper
--   https://docs.google.com/spreadsheets/d/1Vs7LQqS_lfxRGJsp2OFceGYaCCvdDILcFbrKXqMuoEY/edit#gid=0



CREATE TEMP TABLE temp_table_viewers_lifecycle_state_daily_logs (LIKE dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs);


--this deletes the whole thing (ie deletes all rows)
PREPARE the_delete_function_the_viewers_lifecycle_state_daily_logs (BIGINT) AS
DELETE FROM dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs
;

PREPARE the_insert_function_the_viewers_lifecycle_state_daily_logs (BIGINT) AS
INSERT INTO temp_table_viewers_lifecycle_state_daily_logs (
  WITH
  the_parameter_constants AS (
    SELECT $1 AS random_group
  )
  , the_new_born_viewers AS (
    SELECT viewer_id FROM dx_sandbox.dsds_594_new_born_viewers WHERE random_group=$1 GROUP BY 1
  )

  , full_time_frame AS (
    --2019	42	2019-10-14T00:00:00.000Z	2019-10-20T23:59:59.000Z	2019-10-14T00:00:00.000Z	2019-10-20T00:00:00.000Z
    SELECT *
    FROM dx_metadata.wbr_timeframe
    WHERE start_date>='2018-09-24'::DATE AND end_date<='2019-10-20'::DATE
  )
  , viewer_lifecycle_hierarchy AS (
    SELECT 'born'::VARCHAR(25) AS lifecycle_stage, 1::INTEGER AS the_priority
    UNION SELECT 'new'::VARCHAR(25) AS lifecycle_stage, 2::INTEGER AS the_priority
    UNION SELECT 'occasional'::VARCHAR(25) AS lifecycle_stage, 3::INTEGER AS the_priority
    UNION SELECT 'reengaged'::VARCHAR(25) AS lifecycle_stage, 4::INTEGER AS the_priority
    UNION SELECT 'regular'::VARCHAR(25) AS lifecycle_stage, 5::INTEGER AS the_priority

    UNION SELECT 'cold'::VARCHAR(25) AS lifecycle_stage, 98::INTEGER AS the_priority
    UNION SELECT 'frozen'::VARCHAR(25) AS lifecycle_stage, 99::INTEGER AS the_priority
  )

  , lifecycle_state_daily_logs AS (
    SELECT base.*, the_priority
    FROM (
      SELECT day, viewer_id, lifecycle_stage--, active AS flag_active, visitor AS flag_visitor
      FROM cubes.viewer_lifecycle_stage_daily_2020
      WHERE day>=(SELECT MIN(start_date) FROM full_time_frame)
      AND day<=(SELECT MAX(end_date) FROM full_time_frame)
      AND viewer_id IN (SELECT viewer_id FROM the_new_born_viewers)
      GROUP BY 1,2,3
    ) AS base
    LEFT JOIN viewer_lifecycle_hierarchy AS hier ON base.lifecycle_stage = hier.lifecycle_stage
  )

  SELECT * FROM lifecycle_state_daily_logs


);








-- for each week's viewer_id, map to their lifecycle event
-- use the table dx_sandbox.dsds_594_new_born_viewers_weekly_timeline_unique_rows



PREPARE the_delete_function_the_viewers_weekly_timeline_step1 (BIGINT) AS
DELETE FROM dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1
WHERE random_group=$1
;

CREATE TEMP TABLE temp_table_the_viewers_weekly_timeline_step1 (LIKE dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1);

PREPARE the_insert_function_the_viewers_weekly_timeline_step1 (BIGINT) AS
INSERT INTO temp_table_the_viewers_weekly_timeline_step1 (
  WITH
  the_parameter_constants AS (
    SELECT $1 AS random_group
  )
  , the_weekly_logs AS (
    SELECT year, week_number, start_date, end_date, born_day, viewer_id, random_group, the_device_id_array
    FROM dx_sandbox.dsds_594_new_born_viewers_weekly_timeline_unique_rows
    WHERE random_group=$1
  )
  , join_logs AS (
    SELECT year, week_number, start_date, end_date, born_day, random_group, base.viewer_id, the_device_id_array, lifecycle_stage, the_priority
    FROM the_weekly_logs AS base
    LEFT JOIN dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs AS daily ON base.start_date <= daily.day  AND  daily.day <= base.end_date AND base.viewer_id = daily.viewer_id
    GROUP BY 1,2,3,4,5,6,7,8,9,10
  )
  , join_logs_process AS (
    SELECT *, MIN(the_priority) over (PARTITION BY viewer_id, year, week_number) AS the_priority_min
    FROM join_logs
  )
  , final_data AS (
    SELECT year, week_number, start_date, end_date, born_day, random_group, viewer_id, the_device_id_array
      , NVL(lifecycle_stage,'frozen') AS lifecycle_stage
    FROM (
      SELECT *
      FROM join_logs_process
      WHERE the_priority = the_priority_min OR the_priority IS NULL
    )
  )

  SELECT * FROM final_data


);
















-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (0); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (0);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (0); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (0);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (1); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (1);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (1); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (1);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (2); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (2);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (2); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (2);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (3); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (3);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (3); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (3);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (4); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (4);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (4); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (4);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (5); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (5);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (5); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (5);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (6); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (6);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (6); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (6);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (7); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (7);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (7); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (7);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (8); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (8);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (8); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (8);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (9); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (9);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (9); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (9);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (10); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (10);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (10); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (10);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (11); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (11);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (11); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (11);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (12); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (12);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (12); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (12);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (13); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (13);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (13); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (13);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (14); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (14);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (14); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (14);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (15); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (15);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (15); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (15);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (16); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (16);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (16); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (16);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (17); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (17);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (17); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (17);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (18); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (18);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (18); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (18);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (19); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (19);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (19); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (19);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (20); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (20);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (20); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (20);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (21); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (21);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (21); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (21);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (22); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (22);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (22); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (22);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (23); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (23);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (23); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (23);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (24); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (24);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (24); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (24);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (25); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (25);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (25); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (25);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (26); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (26);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (26); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (26);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (27); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (27);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (27); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (27);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (28); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (28);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (28); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (28);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (29); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (29);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (29); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (29);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;


-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (30); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (30);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (30); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (30);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (31); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (31);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (31); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (31);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (32); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (32);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (32); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (32);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (33); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (33);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (33); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (33);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (34); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (34);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (34); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (34);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (35); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (35);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (35); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (35);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (36); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (36);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (36); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (36);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (37); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (37);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (37); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (37);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (38); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (38);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (38); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (38);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (39); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (39);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (39); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (39);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
--
--
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (40); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (40);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (40); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (40);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (41); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (41);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (41); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (41);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (42); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (42);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (42); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (42);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (43); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (43);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (43); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (43);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (44); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (44);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (44); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (44);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (45); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (45);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (45); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (45);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (46); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (46);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (46); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (46);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (47); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (47);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (47); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (47);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (48); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (48);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (48); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (48);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (49); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (49);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (49); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (49);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
--
--
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (50); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (50);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (50); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (50);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (51); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (51);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (51); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (51);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (52); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (52);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (52); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (52);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (53); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (53);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (53); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (53);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (54); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (54);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (54); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (54);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (55); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (55);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (55); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (55);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (56); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (56);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (56); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (56);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (57); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (57);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (57); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (57);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (58); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (58);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (58); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (58);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (59); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (59);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (59); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (59);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
--
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (60); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (60);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (60); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (60);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (61); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (61);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (61); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (61);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (62); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (62);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (62); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (62);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (63); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (63);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (63); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (63);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (64); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (64);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (64); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (64);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (65); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (65);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (65); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (65);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (66); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (66);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (66); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (66);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (67); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (67);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (67); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (67);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (68); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (68);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (68); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (68);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (69); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (69);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (69); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (69);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
--
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (70); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (70);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (70); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (70);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (71); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (71);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (71); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (71);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (72); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (72);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (72); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (72);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (73); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (73);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (73); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (73);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (74); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (74);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (74); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (74);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (75); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (75);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (75); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (75);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (76); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (76);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (76); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (76);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (77); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (77);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (77); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (77);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (78); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (78);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (78); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (78);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (79); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (79);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (79); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (79);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
--
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (80); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (80);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (80); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (80);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (81); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (81);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (81); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (81);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (82); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (82);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (82); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (82);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (83); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (83);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (83); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (83);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (84); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (84);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (84); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (84);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (85); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (85);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (85); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (85);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (86); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (86);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (86); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (86);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (87); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (87);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (87); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (87);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (88); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (88);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (88); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (88);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (89); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (89);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (89); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (89);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
--
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (90); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (90);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (90); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (90);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (91); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (91);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (91); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (91);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (92); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (92);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (92); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (92);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (93); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (93);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (93); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (93);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (94); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (94);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (94); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (94);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (95); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (95);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (95); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (95);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (96); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (96);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (96); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (96);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (97); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (97);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (97); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (97);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (98); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (98);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (98); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (98);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (99); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (99);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (99); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (99);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;

-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (100); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (100);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (100); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (100);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (101); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (101);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (101); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (101);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (102); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (102);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (102); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (102);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (103); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (103);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (103); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (103);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (104); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (104);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (104); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (104);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (105); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (105);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (105); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (105);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (106); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (106);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (106); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (106);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (107); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (107);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (107); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (107);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (108); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (108);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (108); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (108);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (109); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (109);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (109); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (109);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
--
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (110); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (110);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (110); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (110);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (111); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (111);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (111); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (111);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (112); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (112);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (112); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (112);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (113); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (113);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (113); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (113);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (114); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (114);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (114); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (114);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (115); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (115);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (115); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (115);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (116); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (116);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (116); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (116);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (117); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (117);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (117); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (117);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (118); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (118);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (118); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (118);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (119); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (119);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (119); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (119);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
--
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (120); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (120);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (120); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (120);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (121); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (121);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (121); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (121);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (122); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (122);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (122); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (122);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (123); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (123);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (123); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (123);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (124); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (124);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (124); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (124);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (125); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (125);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (125); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (125);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (126); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (126);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (126); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (126);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (127); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (127);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (127); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (127);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (128); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (128);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (128); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (128);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (129); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (129);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (129); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (129);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
--
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (130); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (130);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (130); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (130);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (131); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (131);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (131); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (131);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (132); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (132);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (132); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (132);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (133); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (133);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (133); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (133);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (134); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (134);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (134); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (134);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (135); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (135);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (135); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (135);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (136); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (136);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (136); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (136);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (137); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (137);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (137); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (137);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (138); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (138);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (138); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (138);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (139); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (139);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (139); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (139);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
--
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (140); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (140);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (140); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (140);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (141); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (141);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (141); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (141);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (142); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (142);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (142); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (142);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (143); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (143);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (143); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (143);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (144); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (144);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (144); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (144);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (145); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (145);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (145); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (145);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (146); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (146);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (146); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (146);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (147); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (147);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (147); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (147);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (148); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (148);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (148); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (148);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (149); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (149);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (149); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (149);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
--
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (150); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (150);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (150); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (150);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (151); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (151);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (151); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (151);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (152); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (152);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (152); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (152);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (153); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (153);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (153); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (153);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (154); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (154);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (154); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (154);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (155); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (155);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (155); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (155);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (156); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (156);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (156); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (156);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (157); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (157);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (157); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (157);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (158); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (158);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (158); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (158);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (159); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (159);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (159); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (159);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
--
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (160); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (160);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (160); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (160);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (161); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (161);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (161); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (161);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (162); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (162);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (162); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (162);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (163); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (163);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (163); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (163);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (164); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (164);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (164); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (164);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (165); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (165);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (165); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (165);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (166); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (166);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (166); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (166);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (167); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (167);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (167); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (167);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (168); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (168);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (168); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (168);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (169); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (169);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (169); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (169);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
--
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (170); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (170);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (170); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (170);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (171); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (171);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (171); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (171);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (172); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (172);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (172); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (172);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (173); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (173);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (173); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (173);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (174); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (174);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (174); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (174);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (175); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (175);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (175); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (175);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (176); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (176);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (176); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (176);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (177); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (177);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (177); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (177);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (178); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (178);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (178); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (178);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (179); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (179);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (179); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (179);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
--
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (180); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (180);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (180); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (180);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (181); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (181);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (181); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (181);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (182); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (182);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (182); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (182);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (183); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (183);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (183); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (183);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (184); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (184);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (184); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (184);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (185); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (185);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (185); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (185);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (186); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (186);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (186); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (186);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (187); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (187);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (187); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (187);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (188); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (188);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (188); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (188);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (189); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (189);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (189); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (189);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
--
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (190); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (190);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (190); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (190);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (191); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (191);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (191); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (191);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (192); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (192);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (192); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (192);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (193); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (193);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (193); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (193);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (194); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (194);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (194); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (194);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (195); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (195);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (195); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (195);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (196); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (196);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (196); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (196);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (197); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (197);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (197); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (197);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (198); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (198);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (198); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (198);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
-- EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (199); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (199);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
-- EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (199); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (199);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;














EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (700); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (700);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (700); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (700);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (701); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (701);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (701); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (701);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (702); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (702);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (702); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (702);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (703); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (703);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (703); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (703);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (704); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (704);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (704); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (704);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (705); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (705);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (705); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (705);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (706); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (706);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (706); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (706);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (707); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (707);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (707); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (707);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (708); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (708);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (708); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (708);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (709); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (709);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (709); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (709);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;

EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (710); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (710);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (710); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (710);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (711); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (711);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (711); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (711);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (712); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (712);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (712); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (712);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (713); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (713);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (713); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (713);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (714); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (714);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (714); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (714);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (715); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (715);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (715); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (715);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (716); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (716);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (716); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (716);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (717); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (717);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (717); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (717);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (718); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (718);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (718); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (718);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (719); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (719);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (719); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (719);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;

EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (720); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (720);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (720); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (720);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (721); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (721);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (721); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (721);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (722); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (722);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (722); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (722);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (723); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (723);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (723); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (723);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (724); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (724);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (724); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (724);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (725); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (725);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (725); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (725);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (726); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (726);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (726); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (726);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (727); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (727);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (727); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (727);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (728); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (728);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (728); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (728);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (729); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (729);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (729); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (729);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;

EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (730); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (730);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (730); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (730);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (731); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (731);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (731); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (731);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (732); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (732);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (732); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (732);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (733); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (733);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (733); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (733);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (734); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (734);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (734); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (734);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (735); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (735);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (735); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (735);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (736); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (736);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (736); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (736);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (737); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (737);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (737); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (737);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (738); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (738);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (738); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (738);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (739); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (739);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (739); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (739);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;

EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (740); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (740);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (740); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (740);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (741); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (741);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (741); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (741);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (742); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (742);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (742); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (742);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (743); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (743);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (743); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (743);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (744); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (744);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (744); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (744);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (745); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (745);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (745); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (745);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (746); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (746);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (746); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (746);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (747); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (747);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (747); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (747);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (748); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (748);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (748); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (748);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (749); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (749);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (749); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (749);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;

EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (750); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (750);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (750); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (750);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (751); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (751);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (751); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (751);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (752); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (752);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (752); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (752);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (753); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (753);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (753); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (753);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (754); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (754);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (754); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (754);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (755); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (755);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (755); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (755);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (756); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (756);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (756); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (756);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (757); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (757);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (757); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (757);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (758); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (758);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (758); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (758);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (759); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (759);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (759); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (759);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;

EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (760); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (760);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (760); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (760);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (761); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (761);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (761); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (761);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (762); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (762);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (762); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (762);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (763); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (763);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (763); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (763);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (764); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (764);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (764); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (764);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (765); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (765);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (765); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (765);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (766); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (766);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (766); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (766);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (767); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (767);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (767); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (767);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (768); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (768);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (768); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (768);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (769); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (769);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (769); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (769);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;

EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (770); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (770);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (770); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (770);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (771); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (771);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (771); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (771);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (772); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (772);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (772); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (772);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (773); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (773);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (773); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (773);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (774); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (774);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (774); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (774);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (775); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (775);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (775); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (775);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (776); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (776);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (776); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (776);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (777); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (777);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (777); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (777);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (778); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (778);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (778); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (778);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (779); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (779);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (779); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (779);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;

EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (780); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (780);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (780); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (780);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (781); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (781);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (781); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (781);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (782); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (782);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (782); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (782);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (783); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (783);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (783); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (783);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (784); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (784);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (784); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (784);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (785); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (785);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (785); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (785);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (786); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (786);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (786); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (786);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (787); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (787);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (787); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (787);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (788); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (788);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (788); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (788);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (789); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (789);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (789); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (789);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;

EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (790); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (790);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (790); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (790);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (791); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (791);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (791); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (791);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (792); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (792);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (792); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (792);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (793); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (793);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (793); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (793);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (794); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (794);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (794); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (794);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (795); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (795);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (795); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (795);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (796); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (796);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (796); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (796);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (797); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (797);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (797); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (797);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (798); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (798);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (798); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (798);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (799); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (799);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (799); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (799);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;


EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (800); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (800);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (800); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (800);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (801); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (801);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (801); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (801);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (802); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (802);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (802); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (802);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (803); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (803);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (803); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (803);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (804); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (804);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (804); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (804);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (805); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (805);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (805); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (805);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (806); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (806);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (806); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (806);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (807); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (807);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (807); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (807);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (808); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (808);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (808); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (808);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (809); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (809);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (809); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (809);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;

EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (810); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (810);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (810); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (810);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (811); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (811);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (811); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (811);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (812); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (812);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (812); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (812);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (813); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (813);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (813); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (813);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (814); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (814);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (814); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (814);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (815); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (815);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (815); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (815);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (816); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (816);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (816); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (816);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (817); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (817);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (817); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (817);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (818); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (818);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (818); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (818);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (819); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (819);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (819); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (819);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;

EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (820); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (820);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (820); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (820);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (821); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (821);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (821); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (821);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (822); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (822);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (822); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (822);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (823); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (823);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (823); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (823);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (824); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (824);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (824); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (824);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (825); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (825);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (825); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (825);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (826); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (826);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (826); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (826);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (827); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (827);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (827); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (827);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (828); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (828);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (828); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (828);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (829); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (829);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (829); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (829);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;

EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (830); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (830);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (830); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (830);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (831); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (831);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (831); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (831);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (832); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (832);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (832); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (832);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (833); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (833);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (833); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (833);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (834); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (834);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (834); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (834);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (835); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (835);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (835); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (835);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (836); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (836);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (836); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (836);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (837); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (837);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (837); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (837);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (838); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (838);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (838); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (838);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (839); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (839);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (839); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (839);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;

EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (840); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (840);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (840); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (840);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (841); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (841);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (841); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (841);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (842); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (842);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (842); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (842);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (843); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (843);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (843); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (843);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (844); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (844);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (844); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (844);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (845); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (845);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (845); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (845);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (846); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (846);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (846); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (846);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (847); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (847);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (847); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (847);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (848); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (848);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (848); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (848);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (849); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (849);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (849); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (849);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;

EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (850); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (850);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (850); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (850);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (851); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (851);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (851); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (851);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (852); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (852);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (852); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (852);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (853); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (853);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (853); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (853);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (854); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (854);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (854); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (854);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (855); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (855);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (855); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (855);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (856); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (856);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (856); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (856);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (857); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (857);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (857); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (857);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (858); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (858);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (858); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (858);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (859); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (859);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (859); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (859);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;

EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (860); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (860);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (860); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (860);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (861); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (861);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (861); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (861);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (862); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (862);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (862); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (862);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (863); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (863);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (863); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (863);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (864); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (864);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (864); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (864);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (865); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (865);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (865); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (865);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (866); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (866);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (866); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (866);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (867); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (867);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (867); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (867);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (868); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (868);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (868); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (868);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (869); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (869);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (869); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (869);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;

EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (870); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (870);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (870); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (870);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (871); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (871);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (871); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (871);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (872); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (872);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (872); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (872);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (873); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (873);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (873); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (873);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (874); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (874);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (874); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (874);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (875); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (875);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (875); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (875);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (876); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (876);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (876); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (876);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (877); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (877);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (877); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (877);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (878); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (878);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (878); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (878);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (879); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (879);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (879); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (879);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;

EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (880); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (880);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (880); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (880);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (881); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (881);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (881); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (881);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (882); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (882);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (882); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (882);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (883); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (883);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (883); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (883);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (884); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (884);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (884); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (884);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (885); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (885);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (885); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (885);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (886); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (886);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (886); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (886);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (887); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (887);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (887); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (887);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (888); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (888);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (888); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (888);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (889); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (889);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (889); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (889);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;

EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (890); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (890);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (890); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (890);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (891); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (891);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (891); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (891);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (892); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (892);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (892); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (892);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (893); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (893);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (893); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (893);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (894); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (894);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (894); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (894);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (895); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (895);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (895); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (895);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (896); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (896);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (896); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (896);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (897); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (897);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (897); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (897);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (898); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (898);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (898); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (898);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (899); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (899);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (899); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (899);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;

EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (900); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (900);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (900); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (900);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (901); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (901);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (901); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (901);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (902); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (902);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (902); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (902);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (903); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (903);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (903); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (903);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (904); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (904);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (904); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (904);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (905); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (905);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (905); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (905);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (906); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (906);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (906); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (906);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (907); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (907);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (907); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (907);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (908); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (908);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (908); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (908);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (909); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (909);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (909); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (909);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;

EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (910); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (910);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (910); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (910);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (911); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (911);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (911); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (911);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (912); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (912);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (912); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (912);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (913); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (913);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (913); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (913);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (914); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (914);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (914); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (914);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (915); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (915);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (915); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (915);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (916); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (916);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (916); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (916);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (917); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (917);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (917); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (917);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (918); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (918);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (918); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (918);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (919); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (919);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (919); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (919);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;

EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (920); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (920);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (920); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (920);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (921); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (921);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (921); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (921);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (922); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (922);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (922); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (922);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (923); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (923);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (923); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (923);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (924); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (924);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (924); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (924);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (925); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (925);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (925); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (925);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (926); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (926);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (926); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (926);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (927); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (927);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (927); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (927);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (928); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (928);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (928); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (928);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (929); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (929);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (929); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (929);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;

EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (930); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (930);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (930); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (930);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (931); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (931);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (931); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (931);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (932); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (932);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (932); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (932);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (933); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (933);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (933); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (933);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (934); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (934);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (934); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (934);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (935); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (935);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (935); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (935);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (936); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (936);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (936); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (936);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (937); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (937);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (937); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (937);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (938); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (938);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (938); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (938);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (939); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (939);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (939); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (939);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;

EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (940); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (940);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (940); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (940);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (941); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (941);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (941); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (941);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (942); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (942);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (942); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (942);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (943); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (943);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (943); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (943);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (944); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (944);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (944); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (944);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (945); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (945);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (945); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (945);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (946); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (946);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (946); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (946);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (947); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (947);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (947); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (947);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (948); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (948);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (948); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (948);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (949); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (949);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (949); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (949);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;

EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (950); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (950);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (950); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (950);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (951); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (951);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (951); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (951);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (952); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (952);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (952); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (952);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (953); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (953);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (953); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (953);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (954); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (954);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (954); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (954);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (955); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (955);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (955); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (955);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (956); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (956);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (956); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (956);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (957); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (957);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (957); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (957);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (958); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (958);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (958); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (958);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (959); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (959);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (959); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (959);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;

EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (960); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (960);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (960); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (960);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (961); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (961);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (961); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (961);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (962); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (962);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (962); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (962);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (963); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (963);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (963); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (963);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (964); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (964);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (964); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (964);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (965); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (965);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (965); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (965);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (966); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (966);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (966); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (966);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (967); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (967);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (967); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (967);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (968); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (968);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (968); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (968);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (969); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (969);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (969); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (969);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;

EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (970); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (970);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (970); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (970);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (971); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (971);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (971); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (971);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (972); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (972);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (972); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (972);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (973); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (973);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (973); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (973);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (974); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (974);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (974); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (974);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (975); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (975);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (975); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (975);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (976); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (976);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (976); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (976);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (977); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (977);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (977); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (977);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (978); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (978);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (978); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (978);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (979); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (979);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (979); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (979);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;

EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (980); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (980);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (980); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (980);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (981); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (981);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (981); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (981);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (982); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (982);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (982); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (982);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (983); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (983);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (983); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (983);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (984); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (984);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (984); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (984);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (985); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (985);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (985); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (985);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (986); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (986);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (986); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (986);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (987); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (987);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (987); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (987);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (988); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (988);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (988); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (988);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (989); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (989);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (989); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (989);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;

EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (990); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (990);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (990); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (990);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (991); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (991);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (991); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (991);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (992); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (992);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (992); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (992);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (993); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (993);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (993); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (993);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (994); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (994);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (994); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (994);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (995); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (995);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (995); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (995);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (996); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (996);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (996); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (996);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (997); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (997);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (997); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (997);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (998); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (998);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (998); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (998);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
EXECUTE the_insert_function_the_viewers_lifecycle_state_daily_logs (999); EXECUTE the_delete_function_the_viewers_lifecycle_state_daily_logs (999);   INSERT INTO dx_sandbox.dsds_594_the_viewers_lifecycle_state_daily_logs    (SELECT * FROM temp_table_viewers_lifecycle_state_daily_logs);  DELETE FROM temp_table_viewers_lifecycle_state_daily_logs;
EXECUTE the_insert_function_the_viewers_weekly_timeline_step1 (999); EXECUTE the_delete_function_the_viewers_weekly_timeline_step1 (999);   INSERT INTO dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1    (SELECT * FROM temp_table_the_viewers_weekly_timeline_step1);  DELETE FROM temp_table_the_viewers_weekly_timeline_step1;
