DROP TABLE IF EXISTS dx_sandbox.dsds_594_the_viewers_weekly_timeline_step2;
CREATE TABLE dx_sandbox.dsds_594_the_viewers_weekly_timeline_step2 AS


WITH


--used for json_decompress
n_table AS (
    SELECT n FROM dx_metadata.number_series
    WHERE n>=0 AND n<=2 GROUP BY 1
)

-- -- year | week_number | start_date |  end_date  |  born_day  | random_group | viewer_id |         the_device_id_array          | lifecycle_stage
-- the_logs AS (
--   SELECT *
--   FROM dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1
--   WHERE viewer_id IN (154605684,264507583,247262765)
-- )


--decompress   the_device_id_array   into singleton device_id rows, then remap it to viewer_id
--http://torsten.io/stdout/expanding-json-arrays-to-rows/
, the_device_id_array_decompress AS (
  SELECT viewer_id, json_extract_array_element_text(the_device_id_array, n) AS device_id, the_device_id_array
  FROM dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1, n_table
  --FROM the_logs, n_table
  WHERE n < JSON_ARRAY_LENGTH(the_device_id_array)
  GROUP BY  1,2,3
)

--remap device_id into a new the_device_id_array for every viewer_id
, the_device_id_recompress AS (
  SELECT viewer_id, '['||the_device_id_list||']' AS the_device_id_array
  FROM (
    SELECT viewer_id
      , listagg('"'||device_id||'"', ',') WITHIN GROUP (ORDER BY device_id) AS the_device_id_list
    FROM the_device_id_array_decompress
    GROUP BY 1
  )
)
--
-- SELECT *, is_valid_json_array(the_device_id_array) FROM the_device_id_recompress ORDER BY 1,2
-- ;






--take unique year, week_number, start_date, end_date, born_day, viewer_id, lifecycle_stage to ensure "1 row per viewer per week"
, viewer_weekly_lifecycle_stage AS (
  SELECT year, week_number, start_date, end_date, born_day, viewer_id, lifecycle_stage
  FROM dx_sandbox.dsds_594_the_viewers_weekly_timeline_step1
  --FROM the_logs
  GROUP BY 1,2,3,4,5,6,7
)


-- join on viewer_id to get the new   the_device_id_array   in the table
, join_data AS (
  SELECT year, week_number, start_date, end_date, born_day, base.viewer_id, the_device_id_array, lifecycle_stage
  FROM viewer_weekly_lifecycle_stage AS base
  LEFT JOIN the_device_id_recompress AS device ON base.viewer_id = device.viewer_id
)

SELECT * FROM join_data

--ORDER BY viewer_id, year, week_number
;
