-- -- QA the table dx_sandbox.dsds_594_the_viewers_weekly_timeline_step2

dsds_594_the_viewers_weekly_timeline_step2




SELECT COUNT(DISTINCT viewer_id) AS viewers, COUNT(1) AS rows, COUNT(DISTINCT start_date) AS weeks
FROM dx_sandbox.dsds_594_the_viewers_weekly_timeline_step2
;


-- fixed?
SELECT *
FROM dx_sandbox.dsds_594_the_viewers_weekly_timeline_step2
WHERE viewer_id IN (154605684,264507583)
ORDER BY viewer_id, year, week_number
;


-- NO ISSUES HERE WITH A GIVEN viewer_id HAVING MULTIPLE lifecycle_stage IN THE SAME WEEK! YAY!!
WITH
lifecycle_error_ids AS (
  SELECT viewer_id
  FROM (
    SELECT year, week_number, viewer_id, COUNT(DISTINCT lifecycle_stage) AS lifecycle_stages, COUNT(1) AS rows
    FROM dx_sandbox.dsds_594_the_viewers_weekly_timeline_step2
    GROUP BY 1,2,3
  )
  WHERE lifecycle_stages>1
  GROUP BY 1
)

SELECT *
FROM dx_sandbox.dsds_594_the_viewers_weekly_timeline_step2
WHERE viewer_id IN (SELECT viewer_id FROM lifecycle_error_ids)
ORDER BY viewer_id, year, week_number
;




--calculate the % that a viewer_id has "regular"
WITH
viewer_pct_regular AS (
  SELECT viewer_id, SUM(CASE WHEN lifecycle_stage='regular' THEN 1::FLOAT ELSE 0::FLOAT END)/COUNT(1) AS pct_regular
  FROM dx_sandbox.dsds_594_the_viewers_weekly_timeline_step2
  GROUP BY 1
)
SELECT pct_regular, COUNT(DISTINCT viewer_id) As viewers, COUNT(1)
FROM viewer_pct_regular
GROUP BY 1
ORDER BY 2 DESC
