-- get geo distribution of extension devs, drops devs, ecosystem devs, other game devs

WITH
the_timeframe AS (
SELECT '2017-05-24 13:00:00'::timestamp AS start_time_extension
, '2017-02-22 00:00:00'::timestamp AS start_time_drops
, '2015-03-24 00:00:00'::timestamp AS start_time_tools
, '2017-10-10 00:00:00'::timestamp AS end_time
)


, tools_list AS (
SELECT oc.id AS client_row_id, oc.client_id, oc.name AS app_name, oc.oauth2_client_owner_id AS app_user_id, oc.redirect_uri, su.country
FROM analysis.sitedb_oauth2_clients AS oc
LEFT JOIN analysis.sitedb_users AS su ON oc.oauth2_client_owner_id=su.user_id
WHERE is_first_party IS FALSE
)

, the_tools_ecosystem AS (
SELECT DATE_TRUNC('month', "time") AS the_month, oa.client_id, al.app_name, al.app_user_id, al.country
, CASE WHEN oa.client_id IN ('fnkzwj509yyr3u76ltk57nzhkhdd8g','mlpjzuoqffzsj3obfbtwhlxeuepuvh','t11hnc4bu1xj2yljd1t4dbruut4srkf','pdw11y2y3bdtadcyknd791u6mqrqry','tmc0eeve0f275a2s00faieyqk7gy9qm','bs3mowbbusifs5b0rm43e9adg2k3nq','mfieqnayt3vog4ucp023xjmdcoh35nu','saactj7j6kcf5ogqcv4n6zsgx32sy41','ej2jcvrrou83mzux1qqwp0hv6ohb7ax','v2cr7jjy56uvdjnmd9nbeabp64wzz9','r1vlp9pn0fzavyojluufon1hmwf777t','vq43jmt5rtundmjzkkm6u21y08lkf6','ekuxj9v9seky40ifo38jb4kj6','4g25xyv5yvrfjc5w8yoiadvidxikl0','euq9t2u79ne77aw5s5qtu3sinciodg','dl30ebfpmbbr4yvmm4as39xk6u034s5','9jkmuhd8bp3nkdeo64589r484bxhrw','jw1kuu4g04w8zdw47voajj7z43o6e8v','52bi3askk5pcwenzrymhsu1hkh0fbyi','s5nmfixcax6f9zez4qdcm8ihoh5qxc','lkc5k0aumc4b50itqpg9rr072aogz3','dw1segz99n0yo3y4lngcph092b232v1','gxzfpwu3ru0nzhpclkk8ysgmf0qz3ew','ayt99vsu56rd21c5sik9xnf4sobk27c','ujqk2o5o359jvwsom0se03i399m2ge','t38sga9dornrua56h1ms25jkvpq45bh','4kjaf5nrozsulajftvj279x0uc0m24n','ap6jt6jjmgb59g5zogul1yy57evir42','scebbvo4p4ss20y1qxys6u1sfl07qth','6o7a8hjdvsxjazsd36rd69h8yygtdix','o3vxecfzi4v1r4mkzxsk3tifgijpjo','bszina5udclg8vhg10jf2y08cm366a8','eatppprz6357j6ofcc0bkonrjwd8l61','o3qkq9wrb3sewdpltereobqlrt2nqf2','fteyilxjiqtsh3n6xcyunowg1k7nrwl','6x6zbebbuqk6m0h1mkoxy0rxfdak0cb','t8w2jadpw06vir58z12fg54rfuf66yw','p7125fhexp6wohnj0jxqo49jb6ozefk','l2de47fm6e7j3hc1vvb1lvvue1agwmx','nwbx1xcah7tihpzo22o0fmi41chvm9g') THEN 'game_client_id'
ELSE 'ecosystem_client_id' END AS apps_type
FROM logs.oauth_authorize AS oa
RIGHT JOIN tools_list AS al ON oa.client_id = al.client_id
WHERE "time">=(SELECT start_time_tools FROM the_timeframe)
AND "time"<(SELECT end_time FROM the_timeframe)
)

, devs_ecosystem AS (
SELECT the_month, country, COUNT(DISTINCT app_user_id) AS num_devs_ecosystem
FROM the_tools_ecosystem
GROUP BY 1,2
)



SELECT *
FROM devs_ecosystem AS de
ORDER BY 1,2
