--NOTE: spec for dx_rollup.active_viewer_of_game
-- the_day
-- platform
-- channel_id
-- game
-- game_flattened
-- user_id
-- device_id


-- CHANGE the_index_date IF YOU WANT TO CHANGE THE RELATIVE DATE
CREATE TEMP TABLE the_dates_table AS (
  SELECT DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours'))::DATE AS the_index_date --today's start date
);

DROP TABLE IF EXISTS dx_rollup.active_viewer_of_game;
CREATE TABLE dx_rollup.active_viewer_of_game AS
WITH

the_constants_date AS (
  SELECT DATEADD('day', -1, the_index_date) AS the_day
  FROM the_dates_table
)

, fmp_logs AS (
  SELECT date, "time", device_id, user_id, channel_id, game, platform
  FROM cubes.five_minute_plays
  WHERE date = (SELECT the_day FROM the_constants_date)
)

, final_data AS (
  SELECT date AS the_day, platform, channel_id, game, f_game_flattened(game) AS game_flattened, user_id, device_id
  FROM fmp_logs
  GROUP BY 1,2,3,4,5,6,7
)


SELECT * FROM final_data
;
