DROP TABLE IF EXISTS dx_rollup.active_streamer_of_game;
CREATE TABLE dx_rollup.active_streamer_of_game AS

WITH

the_constants_date AS (
  SELECT DATEADD('day', -1, the_date_today) AS the_day
    , DATEADD('day', -7, the_date_today) AS rolling_7_day_start
    , DATEADD('day', -1, the_date_today) AS rolling_7_day_end
  FROM (SELECT DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours')) AS the_date_today)
)

, the_constants_other AS (
  SELECT 83828553::BIGINT AS the_channel_id -- acs
    , 'live'::VARCHAR(10) AS the_live_string
    , 0::BIGINT AS invalid_channel_category_id --at the start of stream this shows null data for some fields so ignoring
    , 30::BIGINT AS is_active_streamer_of_game_cutoff -- stream at least 30 mins
)

, liveline_logs AS (
  SELECT date, DATE_TRUNC('minute', "time") AS "time", channel_id, channel_category_id, channel_category_name AS game, f_game_flattened(channel_category_name) AS game_flattened--, channel_title
  FROM spade.liveline_channel
  WHERE
    date>=(SELECT rolling_7_day_start FROM the_constants_date) AND date<=(SELECT rolling_7_day_end FROM the_constants_date)
    AND channel_category_id<>(SELECT invalid_channel_category_id FROM the_constants_other) --at the start of stream this shows null data for some fields so ignoring
    AND stream_type = (SELECT the_live_string FROM the_constants_other)
    AND date IS NOT NULL
    AND "time" IS NOT NULL
    AND channel_id IS NOT NULL
    AND channel_category_id IS NOT NULL
    AND channel_category_name IS NOT NULL 
    --AND channel_id = (SELECT the_channel_id FROM the_constants_other)
    --AND channel_category_id = 21779
  GROUP BY 1,2,3,4,5,6
)

, agg_data AS (
  SELECT game, game_flattened, channel_id, SUM(1) AS mb_of_game_rolling_7_day
  FROM liveline_logs
  GROUP BY 1,2,3
)

, final_data AS (
  SELECT
    (SELECT the_day FROM the_constants_date) AS the_day
    , (SELECT rolling_7_day_start FROM the_constants_date) AS rolling_7_day_start
    , (SELECT rolling_7_day_end FROM the_constants_date) AS rolling_7_day_end
    , game, game_flattened, channel_id, mb_of_game_rolling_7_day
    , CASE WHEN mb_of_game_rolling_7_day>=(SELECT is_active_streamer_of_game_cutoff FROM the_constants_other) THEN TRUE ELSE FALSE END AS is_active_streamer_of_game
  FROM agg_data
)

SELECT * FROM final_data
;
