-- by yanghung
-- generate broadcaster test group - activated Muxy/Streamlabs sometime between 2016-08-01 and 2017-05-01 and have >= 2 months of streaming history before activation date
DROP TABLE IF EXISTS    analysis.panalysis879_broadcaster_test;
CREATE TABLE    analysis.panalysis879_broadcaster_test    AS


WITH
potential_broadcasters AS (
  SELECT pb.*, fb.first_broadcast_time
  FROM (
    SELECT * FROM analysis.panalysis879_oauth_streamlabs_muxy
    WHERE (abs_min_time>='2016-08-01' AND abs_max_time<'2017-05-01') -- activated Muxy/Streamlabs sometime between 2016-08-01 and 2017-05-01
  ) AS pb
  LEFT JOIN (
    SELECT channel_id, MIN(time) AS first_broadcast_time
    FROM logs.minute_broadcast
    GROUP BY channel_id
  ) AS fb ON pb.user_id=fb.channel_id
  WHERE fb.first_broadcast_time<=pb.abs_min_time - INTERVAL '60 days' -- >=2 months of streaming history before activation date
)


SELECT pb.*, bt.channel_id, NVL(bt.mw,0) AS mw, NVL(bt.mb,0) AS mb, NVL(bt.avg_ccu, -1) AS avg_ccu, NVL(bt.tier,'not broadcasting') AS tier
FROM potential_broadcasters AS pb
LEFT JOIN analysis.panalysis879_broadcaster_tier_list AS bt ON pb.user_id=bt.channel_id
;
