-- Test if there's overlap between test and control ids
WITH
the_log AS (
SELECT * FROM analysis.panalysis879_broadcaster_test_control_ids
)

SELECT * FROM
(
SELECT channel_id
, SUM(CASE WHEN the_group='control' THEN 1 ELSE 0 END) AS num_control
, SUM(CASE WHEN the_group='test' THEN 1 ELSE 0 END) AS num_test
FROM the_log
GROUP BY channel_id
)
WHERE num_control>1 OR num_test>1
