-- by yanghung
-- generate broadcaster revenue by day data

DROP TABLE IF EXISTS    analysis.panalysis879_broadcaster_rev_by_day;
CREATE TABLE    analysis.panalysis879_broadcaster_rev_by_day    AS


WITH
rev_on_twitch AS (
  SELECT channel_id, day
  , SUM(CASE WHEN product='samus_sub' THEN gross_revenue ELSE 0 END) AS twitch_rev_prime_sub
  , SUM(CASE WHEN product='samus_sub' THEN channel_revenue ELSE 0 END) AS channel_rev_prime_sub
  , SUM(CASE WHEN product='samus_sub' THEN num_purchasers ELSE 0 END) AS purchasers_prime_sub
  , SUM(CASE WHEN product='samus_sub' THEN transactions ELSE 0 END) AS transactions_prime_sub
  , SUM(CASE WHEN product='channel_paid_sub' THEN gross_revenue ELSE 0 END) AS twitch_rev_paid_sub
  , SUM(CASE WHEN product='channel_paid_sub' THEN channel_revenue ELSE 0 END) AS channel_rev_paid_sub
  , SUM(CASE WHEN product='channel_paid_sub' THEN num_purchasers ELSE 0 END) AS purchasers_paid_sub
  , SUM(CASE WHEN product='channel_paid_sub' THEN transactions ELSE 0 END) AS transactions_paid_sub
  , SUM(CASE WHEN product='bits_used' THEN gross_revenue ELSE 0 END) AS twitch_rev_bits
  , SUM(CASE WHEN product='bits_used' THEN channel_revenue ELSE 0 END) AS channel_rev_bits
  , SUM(CASE WHEN product='bits_used' THEN num_purchasers ELSE 0 END) AS purchasers_bits
  , SUM(CASE WHEN product='bits_used' THEN transactions ELSE 0 END) AS transactions_bits
  FROM analysis.afm_revenue_channel_2016
  WHERE
  "day">='2016-01-01' AND "day"<'2017-08-01'
  GROUP BY channel_id, day
)
, rev_ads AS (
  SELECT channel_id, DATE(report_date) AS day
  , SUM(gross_revenue) AS twitch_rev_ads, SUM(partner_revenue) as channel_rev_ads
  FROM analysis.sitedb_advertising_revenue
  WHERE partner_revenue>0
  GROUP BY channel_id, day
)
, rev_donation_streamlabs AS (
  SELECT broadcaster_twitch_id AS channel_id, DATE("time") AS day
  , SUM(0) AS twitch_rev_donation_streamlabs
  , SUM(usd_amount) AS channel_rev_donation_streamlabs
  , COUNT(DISTINCT viewer_twitch_id) AS purchasers_donation_streamlabs
  , SUM(1) AS transactions_donation_streamlabs
  FROM analysis.panalysis879_tips_log
  WHERE platform='streamlabs'
  AND "time">='2016-07-26' --streamlabs only has data from July 2016 onward
  AND "time"<='2017-06-27' --streamlabs only has data until June 2017
  AND flag_transaction='good' --filter out suspicious activity
  GROUP BY channel_id, day
)
, rev_donation_muxy AS (
  SELECT broadcaster_twitch_id AS channel_id, DATE("time") AS day
  , SUM(0) AS twitch_rev_donation_muxy
  , SUM(usd_amount) AS channel_rev_donation_muxy
  , COUNT(DISTINCT viewer_twitch_id) AS purchasers_donation_muxy
  , SUM(1) AS transactions_donation_muxy
  FROM analysis.panalysis879_tips_log
  WHERE platform='muxy'
  AND "time">='2016-07-26' --streamlabs only has data from July 2016 onward
  AND "time"<='2017-06-27' --streamlabs only has data until June 2017
  AND flag_transaction='good' --filter out suspicious activity
  GROUP BY channel_id, day
)

SELECT base.*
, a.day, a.channel_rev_prime_sub, a.channel_rev_paid_sub, a.channel_rev_bits
, s.twitch_rev_donation_streamlabs, s.channel_rev_donation_streamlabs, s.purchasers_donation_streamlabs, s.transactions_donation_streamlabs
, m.twitch_rev_donation_muxy, m.channel_rev_donation_muxy, m.purchasers_donation_muxy, m.transactions_donation_muxy
, ads.twitch_rev_ads, ads.channel_rev_ads
FROM analysis.panalysis879_broadcaster_test_control_ids AS base
LEFT JOIN rev_on_twitch AS a ON base.channel_id=a.channel_id
LEFT JOIN rev_ads AS ads ON a.channel_id = ads.channel_id AND a.day=ads.day
LEFT JOIN rev_donation_streamlabs s ON a.channel_id = s.channel_id AND a.day=s.day
LEFT JOIN rev_donation_muxy m ON a.channel_id = m.channel_id AND a.day=m.day
;
