-- by yanghung
-- generate list of eligible broadcasters weekly metrics by joining step 7 with step 8
-- >=100 mb, >=500 mw, >=0.01 rev_on_twitch (bits+ads+subs)
-- never banned

DROP TABLE IF EXISTS    analysis.panalysis879_eligible_broadcaster_weekly_lookup;
CREATE TABLE    analysis.panalysis879_eligible_broadcaster_weekly_lookup    AS



SELECT base.channel_id, ids.channel, ids.the_group, ids.tier

, CASE WHEN base.channel_id IN
('12826'
,'76927512'
,'38270518'
,'128000123'
,'46510620'
,'36019511'
,'54933969'
,'57781936'
,'140729335'
,'149747285'
,'42508152'
,'83916371'
,'31239503'
,'40336240'
,'36616300'
,'22510310'
,'94829982'
,'118170488'
,'23675021'
,'20891118'
,'21175297'
,'35936871'
,'24297173'
,'8911047'
,'28462004'
,'109724636'
,'59168409'
,'125766975'
,'10063808'
,'29769280'
,'74055074'
,'29578325'
,'159217791'
,'52229024'
) THEN 'tournament' ELSE ids.the_group END AS the_group_new --if it's a tournament|charity|esports|twitch channel, then create it's own group

, DATE(sm.abs_min_time) AS install_app_day, DATE(sm.streamlabs_min_time) AS install_streamlabs_day, DATE(sm.muxy_min_time) AS install_muxy_day
, base.lifetime_mb, base.lifetime_mw, base.lifetime_rev_on_twitch, base.lifetime_rev_off_twitch
, wl.day
, wl.channel_rev_ads
, wl.channel_rev_ads_week_minus_1
, wl.channel_rev_ads_week_minus_2
, wl.channel_rev_ads_week_minus_3
, wl.channel_rev_ads_week_minus_4
, wl.channel_rev_ads_week_minus_5
, wl.channel_rev_ads_week_minus_6
, wl.channel_rev_ads_week_minus_7
, wl.channel_rev_ads_week_minus_8
, wl.channel_rev_ads_week_plus_1
, wl.channel_rev_ads_week_plus_2
, wl.channel_rev_ads_week_plus_3
, wl.channel_rev_ads_week_plus_4
, wl.channel_rev_ads_week_plus_5
, wl.channel_rev_ads_week_plus_6
, wl.channel_rev_ads_week_plus_7
, wl.channel_rev_ads_week_plus_8
, wl.channel_rev_bits
, wl.channel_rev_bits_week_minus_1
, wl.channel_rev_bits_week_minus_2
, wl.channel_rev_bits_week_minus_3
, wl.channel_rev_bits_week_minus_4
, wl.channel_rev_bits_week_minus_5
, wl.channel_rev_bits_week_minus_6
, wl.channel_rev_bits_week_minus_7
, wl.channel_rev_bits_week_minus_8
, wl.channel_rev_bits_week_plus_1
, wl.channel_rev_bits_week_plus_2
, wl.channel_rev_bits_week_plus_3
, wl.channel_rev_bits_week_plus_4
, wl.channel_rev_bits_week_plus_5
, wl.channel_rev_bits_week_plus_6
, wl.channel_rev_bits_week_plus_7
, wl.channel_rev_bits_week_plus_8
, wl.channel_rev_donation_muxy
, wl.channel_rev_donation_muxy_week_minus_1
, wl.channel_rev_donation_muxy_week_minus_2
, wl.channel_rev_donation_muxy_week_minus_3
, wl.channel_rev_donation_muxy_week_minus_4
, wl.channel_rev_donation_muxy_week_minus_5
, wl.channel_rev_donation_muxy_week_minus_6
, wl.channel_rev_donation_muxy_week_minus_7
, wl.channel_rev_donation_muxy_week_minus_8
, wl.channel_rev_donation_muxy_week_plus_1
, wl.channel_rev_donation_muxy_week_plus_2
, wl.channel_rev_donation_muxy_week_plus_3
, wl.channel_rev_donation_muxy_week_plus_4
, wl.channel_rev_donation_muxy_week_plus_5
, wl.channel_rev_donation_muxy_week_plus_6
, wl.channel_rev_donation_muxy_week_plus_7
, wl.channel_rev_donation_muxy_week_plus_8
, wl.channel_rev_donation_streamlabs
, wl.channel_rev_donation_streamlabs_week_minus_1
, wl.channel_rev_donation_streamlabs_week_minus_2
, wl.channel_rev_donation_streamlabs_week_minus_3
, wl.channel_rev_donation_streamlabs_week_minus_4
, wl.channel_rev_donation_streamlabs_week_minus_5
, wl.channel_rev_donation_streamlabs_week_minus_6
, wl.channel_rev_donation_streamlabs_week_minus_7
, wl.channel_rev_donation_streamlabs_week_minus_8
, wl.channel_rev_donation_streamlabs_week_plus_1
, wl.channel_rev_donation_streamlabs_week_plus_2
, wl.channel_rev_donation_streamlabs_week_plus_3
, wl.channel_rev_donation_streamlabs_week_plus_4
, wl.channel_rev_donation_streamlabs_week_plus_5
, wl.channel_rev_donation_streamlabs_week_plus_6
, wl.channel_rev_donation_streamlabs_week_plus_7
, wl.channel_rev_donation_streamlabs_week_plus_8
, wl.channel_rev_off_twitch
, wl.channel_rev_off_twitch_week_minus_1
, wl.channel_rev_off_twitch_week_minus_2
, wl.channel_rev_off_twitch_week_minus_3
, wl.channel_rev_off_twitch_week_minus_4
, wl.channel_rev_off_twitch_week_minus_5
, wl.channel_rev_off_twitch_week_minus_6
, wl.channel_rev_off_twitch_week_minus_7
, wl.channel_rev_off_twitch_week_minus_8
, wl.channel_rev_off_twitch_week_plus_1
, wl.channel_rev_off_twitch_week_plus_2
, wl.channel_rev_off_twitch_week_plus_3
, wl.channel_rev_off_twitch_week_plus_4
, wl.channel_rev_off_twitch_week_plus_5
, wl.channel_rev_off_twitch_week_plus_6
, wl.channel_rev_off_twitch_week_plus_7
, wl.channel_rev_off_twitch_week_plus_8
, wl.channel_rev_on_twitch
, wl.channel_rev_on_twitch_week_minus_1
, wl.channel_rev_on_twitch_week_minus_2
, wl.channel_rev_on_twitch_week_minus_3
, wl.channel_rev_on_twitch_week_minus_4
, wl.channel_rev_on_twitch_week_minus_5
, wl.channel_rev_on_twitch_week_minus_6
, wl.channel_rev_on_twitch_week_minus_7
, wl.channel_rev_on_twitch_week_minus_8
, wl.channel_rev_on_twitch_week_plus_1
, wl.channel_rev_on_twitch_week_plus_2
, wl.channel_rev_on_twitch_week_plus_3
, wl.channel_rev_on_twitch_week_plus_4
, wl.channel_rev_on_twitch_week_plus_5
, wl.channel_rev_on_twitch_week_plus_6
, wl.channel_rev_on_twitch_week_plus_7
, wl.channel_rev_on_twitch_week_plus_8
, wl.channel_rev_paid_sub
, wl.channel_rev_paid_sub_week_minus_1
, wl.channel_rev_paid_sub_week_minus_2
, wl.channel_rev_paid_sub_week_minus_3
, wl.channel_rev_paid_sub_week_minus_4
, wl.channel_rev_paid_sub_week_minus_5
, wl.channel_rev_paid_sub_week_minus_6
, wl.channel_rev_paid_sub_week_minus_7
, wl.channel_rev_paid_sub_week_minus_8
, wl.channel_rev_paid_sub_week_plus_1
, wl.channel_rev_paid_sub_week_plus_2
, wl.channel_rev_paid_sub_week_plus_3
, wl.channel_rev_paid_sub_week_plus_4
, wl.channel_rev_paid_sub_week_plus_5
, wl.channel_rev_paid_sub_week_plus_6
, wl.channel_rev_paid_sub_week_plus_7
, wl.channel_rev_paid_sub_week_plus_8
, wl.channel_rev_prime_sub
, wl.channel_rev_prime_sub_week_minus_1
, wl.channel_rev_prime_sub_week_minus_2
, wl.channel_rev_prime_sub_week_minus_3
, wl.channel_rev_prime_sub_week_minus_4
, wl.channel_rev_prime_sub_week_minus_5
, wl.channel_rev_prime_sub_week_minus_6
, wl.channel_rev_prime_sub_week_minus_7
, wl.channel_rev_prime_sub_week_minus_8
, wl.channel_rev_prime_sub_week_plus_1
, wl.channel_rev_prime_sub_week_plus_2
, wl.channel_rev_prime_sub_week_plus_3
, wl.channel_rev_prime_sub_week_plus_4
, wl.channel_rev_prime_sub_week_plus_5
, wl.channel_rev_prime_sub_week_plus_6
, wl.channel_rev_prime_sub_week_plus_7
, wl.channel_rev_prime_sub_week_plus_8
, wl.channel_rev_total
, wl.channel_rev_total_week_minus_1
, wl.channel_rev_total_week_minus_2
, wl.channel_rev_total_week_minus_3
, wl.channel_rev_total_week_minus_4
, wl.channel_rev_total_week_minus_5
, wl.channel_rev_total_week_minus_6
, wl.channel_rev_total_week_minus_7
, wl.channel_rev_total_week_minus_8
, wl.channel_rev_total_week_plus_1
, wl.channel_rev_total_week_plus_2
, wl.channel_rev_total_week_plus_3
, wl.channel_rev_total_week_plus_4
, wl.channel_rev_total_week_plus_5
, wl.channel_rev_total_week_plus_6
, wl.channel_rev_total_week_plus_7
, wl.channel_rev_total_week_plus_8
, wl.mins_broadcast
, wl.mins_broadcast_week_minus_1
, wl.mins_broadcast_week_minus_2
, wl.mins_broadcast_week_minus_3
, wl.mins_broadcast_week_minus_4
, wl.mins_broadcast_week_minus_5
, wl.mins_broadcast_week_minus_6
, wl.mins_broadcast_week_minus_7
, wl.mins_broadcast_week_minus_8
, wl.mins_broadcast_week_plus_1
, wl.mins_broadcast_week_plus_2
, wl.mins_broadcast_week_plus_3
, wl.mins_broadcast_week_plus_4
, wl.mins_broadcast_week_plus_5
, wl.mins_broadcast_week_plus_6
, wl.mins_broadcast_week_plus_7
, wl.mins_broadcast_week_plus_8
, wl.mins_watched
, wl.mins_watched_week_minus_1
, wl.mins_watched_week_minus_2
, wl.mins_watched_week_minus_3
, wl.mins_watched_week_minus_4
, wl.mins_watched_week_plus_1
, wl.mins_watched_week_plus_2
, wl.mins_watched_week_plus_3
, wl.mins_watched_week_plus_4
, wl.mins_watched_week_minus_5
, wl.mins_watched_week_minus_6
, wl.mins_watched_week_minus_7
, wl.mins_watched_week_minus_8
, wl.mins_watched_week_plus_5
, wl.mins_watched_week_plus_6
, wl.mins_watched_week_plus_7
, wl.mins_watched_week_plus_8

FROM analysis.panalysis879_eligible_broadcasters AS base
LEFT JOIN analysis.panalysis879_broadcaster_test_control_ids AS ids ON base.channel_id=ids.channel_id
LEFT JOIN analysis.panalysis879_broadcaster_weekly_lookup AS wl ON base.channel_id=wl.channel_id
LEFT JOIN analysis.panalysis879_oauth_streamlabs_muxy AS sm ON base.channel_id = sm.user_id
