-- By yanghung
-- Stats on eligible broadcasters in test and control and tournament
-- These are equivalent to avg per day metrics

SELECT the_group_new, tier
, COUNT(DISTINCT channel_id) AS num_channels
, AVG(mw) AS avg_mw
, AVG(mb) AS avg_mb
, AVG(total_rev) AS avg_total_rev
, AVG(rev_off_twitch) AS avg_rev_off_twitch
, AVG(rev_on_twitch) AS avg_rev_on_twitch
-- , MIN(mw) AS min_mw, AVG(mw) AS avg_mw, MAX(mw) AS max_mw
-- , MIN(mb) AS min_mb, AVG(mb) AS avg_mb, MAX(mb) AS max_mb
-- , MIN(total_rev) AS min_total_rev, AVG(total_rev) AS avg_total_rev, MAX(total_rev) AS max_total_rev
-- , MIN(rev_off_twitch) AS min_rev_off_twitch, AVG(rev_off_twitch) AS avg_rev_off_twitch, MAX(rev_off_twitch) AS max_rev_off_twitch
-- , MIN(rev_on_twitch) AS min_rev_on_twitch, AVG(rev_on_twitch) AS avg_rev_on_twitch, MAX(rev_on_twitch) AS max_rev_on_twitch
FROM
(
SELECT channel_id, the_group_new, tier
, SUM(mins_watched)/SUM(CASE WHEN mins_broadcast<=0 OR mins_broadcast IS NULL THEN 0 ELSE 1 END) AS mw
, SUM(mins_broadcast)/SUM(CASE WHEN mins_broadcast<=0 OR mins_broadcast IS NULL THEN 0 ELSE 1 END) AS mb
, SUM(channel_rev_total)/SUM(CASE WHEN mins_broadcast<=0 OR mins_broadcast IS NULL THEN 0 ELSE 1 END) AS total_rev
, SUM(channel_rev_off_twitch)/SUM(CASE WHEN mins_broadcast<=0 OR mins_broadcast IS NULL THEN 0 ELSE 1 END) AS rev_off_twitch
, SUM(channel_rev_on_twitch)/SUM(CASE WHEN mins_broadcast<=0 OR mins_broadcast IS NULL THEN 0 ELSE 1 END) AS rev_on_twitch
FROM analysis.panalysis879_eligible_broadcaster_weekly_lookup
WHERE day>='2016-05-01'
GROUP BY channel_id, the_group_new, tier
)
GROUP BY the_group_new, tier
ORDER BY the_group_new, tier
