
-- logs.vhs_report: get the "service" field that acts as the match key, but need to get it from game name
-- logs.vhs_link: get the number of user_id that linked their twitch account for the drops campaign

WITH
broadcast_log AS (
SELECT 'jax_live_channel' as the_table, rails_channel_id AS channel_id, LOWER(rails_channel) AS channel_name_lower, usher_id AS stream_id, rails_game_id AS game_id, rails_meta_game AS game
, MIN(time) AS stream_start_time, MAX(time) AS stream_end_time, CAST(EXTRACT(SECONDS FROM (MAX(time) - MIN(time))) AS REAL)/60 AS stream_mins
FROM logs.jax_live_channel
WHERE (time)>='2017-08-24 00:00:00' AND (time)<'2017-08-27 00:00:00' --time frame
AND rails_channel_id =121394866 --QuakeChampions
GROUP BY 1,2,3,4,5,6
)

, vhs_id AS (
SELECT distinct service, lower(game) as game
FROM logs.vhs_report
WHERE lower(game) LIKE '%quake champions%'
)

, vhs_link AS (
SELECT *
FROM logs.vhs_link
WHERE service IN (SELECT service FROM vhs_id)
AND time>= (SELECT MIN(stream_start_time) - INTERVAL '15 minutes' FROM broadcast_log) --start time of stream
AND time<= (SELECT MAX(stream_end_time) + INTERVAL '15 minutes' FROM broadcast_log) --end time of stream
)

SELECT COUNT(DISTINCT user_id) as num_new_account_linked, COUNT(1) as rows  FROM vhs_link WHERE user_id IS NOT NULL AND user_id<>0
