
-- logs.vhs_report: get the "service" field that acts as the match key, but need to get it from game name
-- logs.vhs_link: get the number of user_id that linked their twitch account for the drops campaign

WITH
broadcast_log AS (
SELECT 'jax_live_channel' as the_table, rails_channel_id AS channel_id, LOWER(rails_channel) AS channel_name_lower, usher_id AS stream_id, rails_game_id AS game_id, rails_meta_game AS game
, MIN(time) AS stream_start_time, MAX(time) AS stream_end_time, CAST(EXTRACT(SECONDS FROM (MAX(time) - MIN(time))) AS REAL)/60 AS stream_mins
FROM logs.jax_live_channel
WHERE (time)>='2017-08-24 00:00:00' AND (time)<'2017-08-27 00:00:00' --time frame
AND rails_channel_id =121394866 --QuakeChampions
GROUP BY 1,2,3,4,5,6
)


SELECT COUNT(DISTINCT user_id) AS total_users
FROM logs."minute-watched"
WHERE channel_id = 121394866 --QuakeChampions
AND player<>'frontpage' --not front page
AND time>= (SELECT MIN(stream_start_time) - INTERVAL '15 minutes' FROM broadcast_log) --start time with 15 min buffer
AND time<= (SELECT MAX(stream_end_time) + INTERVAL '15 minutes' FROM broadcast_log) --end time with 15 min buffer
