-- 1) x% of Partner streamers have authorized a third-party app on Twitch
-- 2) Over xx applications are registered on Twitch
-- 3) and we have xx API calls made each minute.

WITH
third_party_apps AS (
SELECT client_id, name AS app_name, is_first_party
FROM analysis.sitedb_oauth2_clients
WHERE is_first_party IS FALSE
GROUP BY 1,2,3
)

, partners AS (
SELECT user_id::VARCHAR
FROM analysis.sitedb_users
WHERE is_partner IS TRUE
GROUP BY 1
)

, partner_oauth AS (
SELECT user_id
FROM logs.oauth_authorize
WHERE
user_id IN (SELECT user_id FROM partners)
AND client_id IN (SELECT client_id FROM third_party_apps)
GROUP BY 1
)

SELECT 'partners_oauth', COUNT(DISTINCT user_id) AS counts FROM partner_oauth
UNION ALL
SELECT 'partners_total', COUNT(DISTINCT user_id) AS counts FROM partners
-- SELECT COUNT(DISTINCT a.user_id) AS partners
-- , COUNT(DISTINCT b.user_id) AS partners_that_oauth
-- , COUNT(DISTINCT b.user_id)::FLOAT / COUNT(DISTINCT a.user_id)::FLOAT AS pct_partners_that_oauth
-- FROM partner_oauth AS a
-- LEFT JOIN partner_oauth AS b ON 1=1
