DROP TABLE IF EXISTS    analysis.panalysis1026_broadcast_log;
CREATE TABLE    analysis.panalysis1026_broadcast_log    AS

WITH
the_timeframe AS (
SELECT '2017-05-24 13:00:00' AS start_time, '2017-08-26 23:59:59' AS end_time
)
, whitelist_channels AS (
SELECT DISTINCT whitelist_broadcaster_id::varchar
FROM analysis.extension_whitelist_broadcaster_latest
)

SELECT rails_channel_id::varchar AS channel_id, LOWER(rails_channel) AS channel_name, usher_id AS stream_id, rails_game_id AS game_id, rails_meta_game AS game
, MIN(time) AS stream_start_time, MAX(time) AS stream_end_time, CAST(EXTRACT(SECONDS FROM (MAX(time) - MIN(time))) AS REAL)/60 AS stream_mins
FROM logs.jax_live_channel
WHERE (time)>=(SELECT start_time FROM the_timeframe) AND (time)<=(SELECT end_time FROM the_timeframe)
AND rails_channel_id IN (SELECT whitelist_broadcaster_id FROM whitelist_channels)
GROUP BY 1,2,3,4,5
;
