DROP TABLE IF EXISTS    analysis.panalysis1026_extension_click_log;
CREATE TABLE    analysis.panalysis1026_extension_click_log    AS


WITH
the_timeframe AS (
SELECT '2017-05-24 13:00:00' AS start_time, '2017-08-26 23:59:59' AS end_time
)
, whitelist_channels AS (
SELECT DISTINCT whitelist_broadcaster_id::varchar
FROM analysis.extension_whitelist_broadcaster_latest
)


SELECT "time", channel_id::varchar, device_id, extension_id, extension_version, 1 AS one_click
FROM logs.extension_click
WHERE (time)>=(SELECT start_time FROM the_timeframe) AND (time)<=(SELECT end_time FROM the_timeframe)
AND channel_id IN (SELECT whitelist_broadcaster_id FROM whitelist_channels)
;
