-- Assumptions:
-- Only broadcasters from PC (no console, no mobile)
-- Look at % of broadcasters using a third party (non-game link) app over the last two years?
-- Apply small bump for our launch and then follow a slightly accelerated growth trajectory similar to 3p API app growth over time


WITH
the_timeframe AS (
SELECT '2017-09-06 16:00:00'::timestamp AS range_start, '2017-09-07 08:00:00'::timestamp AS range_end
)

, extension_activate_log AS (
SELECT COUNT(1) AS instances_activate, COUNT(DISTINCT extension_id) AS unique_extensions_activate, COUNT(DISTINCT channel_id) AS unique_channels_activate
FROM logs.extension_activate AS ea
WHERE ea.time>=(SELECT range_start FROM the_timeframe) and ea.time<(SELECT range_end FROM the_timeframe)
)

, extension_deactivate_log AS (
SELECT COUNT(1) AS instances_deactivate, COUNT(DISTINCT extension_id) AS unique_extensions_deactivate, COUNT(DISTINCT channel_id) AS unique_channels_deactivate
FROM logs.extension_deactivate AS ed
WHERE ed.time>=(SELECT range_start FROM the_timeframe) and ed.time<(SELECT range_end FROM the_timeframe)
)

SELECT rel.extension_name, base.* FROM
(
SELECT DISTINCT extension_id
FROM logs.extension_activate AS ea
WHERE ea.time>=(SELECT range_start FROM the_timeframe) and ea.time<(SELECT range_end FROM the_timeframe)
) AS base
LEFT JOIN analysis.released_extensions_latest AS rel ON base.extension_id = rel.extension_id
--
-- SELECT tt.*, eal.*, edl.*, eal.instances_activate - edl.instances_deactivate AS net_activations
-- FROM extension_activate_log AS eal
-- LEFT JOIN extension_deactivate_log AS edl ON 1=1
-- LEFT JOIN the_timeframe AS tt ON 1=1
