-- Broadcasters w/ an installed extension
-- cumulative total active extensions (both aggregate across all extension and for individual extensions)
-- Total Extensions available for install (released) [maybe not in same dashboard]

WITH
activate_deactivate_timestamp AS (
SELECT 'activate' AS table, '2017-08-01 00:00:00'::timestamp AS range_start, MAX(ea.time)::timestamp AS range_end
FROM logs.extension_activate AS ea
WHERE ea.time>=DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours')) - INTERVAL '1 days' + INTERVAL '0 hours' - INTERVAL '0 seconds' --yesterday's start date at 00:00:00
UNION ALL
SELECT 'deactivate' AS table, '2017-08-01 00:00:00'::timestamp AS range_start, MAX(ed.time)::timestamp AS range_end
FROM logs.extension_deactivate AS ed
WHERE ed.time>=DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours')) - INTERVAL '1 days' + INTERVAL '0 hours' - INTERVAL '0 seconds' --yesterday's start date at 00:00:00
)
, the_timeframe AS (
SELECT DATE_TRUNC('day', range_start) AS start_date, DATE_TRUNC('day', range_end) AS end_date
, DATE_TRUNC('hour', range_start) AS range_start, DATE_TRUNC('hour', range_end) AS range_end
FROM (SELECT MIN(range_start) AS range_start, MIN(range_end) AS range_end FROM activate_deactivate_timestamp)
)

, the_dates AS (
SELECT "date" AS the_date FROM metadata.date WHERE date>=(SELECT start_date FROM the_timeframe) AND date<(SELECT end_date FROM the_timeframe) GROUP BY 1
)

, the_date_range AS (
SELECT DATEADD(hour, 0, the_date) AS start_time, DATEADD(hour, 24, the_date) - INTERVAL '1 seconds' AS end_time
FROM the_dates
ORDER BY 1
)


, extension_activate_log AS (
SELECT ea.time, ea.extension_id, ea.extension_version, REPLACE(rel.extension_name, ',', '') AS extension_name, ea.channel_id, 'activate' AS action
--DATE_TRUNC('hour',ea.time) AS the_hour, rel.extension_name, COUNT(1) AS instances_activate--, COUNT(DISTINCT extension_id) AS unique_extensions_activate, COUNT(DISTINCT channel_id) AS unique_channels_activate
FROM logs.extension_activate AS ea
RIGHT JOIN analysis.released_extensions_latest AS rel ON ea.extension_id = rel.extension_id
WHERE ea.time>=(SELECT range_start FROM the_timeframe) and ea.time<(SELECT range_end FROM the_timeframe)
)
, extension_deactivate_log AS (
SELECT ed.time, ed.extension_id, ed.extension_version, REPLACE(rel.extension_name, ',', '') AS extension_name, ed.channel_id, 'deactivate' AS action
--DATE_TRUNC('hour',ed.time) AS the_hour, COUNT(1) AS instances_deactivate--, COUNT(DISTINCT extension_id) AS unique_extensions_deactivate, COUNT(DISTINCT channel_id) AS unique_channels_deactivate
FROM logs.extension_deactivate AS ed
RIGHT JOIN analysis.released_extensions_latest AS rel ON ed.extension_id = rel.extension_id
WHERE ed.time>=(SELECT range_start FROM the_timeframe) and ed.time<(SELECT range_end FROM the_timeframe)
)

, extension_last_activate AS (
SELECT start_time, end_time, extension_id, extension_name, channel_id, MAX(time) AS last_time_activate
FROM (SELECT base.*, ext.* FROM the_date_range AS base LEFT JOIN extension_activate_log AS ext ON base.end_time>=ext.time)
GROUP BY 1,2,3,4,5
)
, extension_last_deactivate AS (
SELECT start_time, end_time, extension_id, extension_name, channel_id, MAX(time) AS last_time_deactivate
FROM (SELECT base.*, ext.* FROM the_date_range AS base LEFT JOIN extension_deactivate_log AS ext ON base.end_time>=ext.time)
GROUP BY 1,2,3,4,5
)

, the_final_table AS (
SELECT act.*, deact.last_time_deactivate, CASE WHEN last_time_deactivate>last_time_activate THEN 0 ELSE 1 END AS flag_is_active
FROM extension_last_activate AS act
LEFT JOIN extension_last_deactivate AS deact
ON act.start_time = deact.start_time AND act.end_time = deact.end_time AND act.extension_id = deact.extension_id AND act.channel_id = deact.channel_id
)

SELECT start_time, end_time, 'ALL' AS extension_id, 'ALL' AS extension_name, SUM(flag_is_active) AS active_extensions, COUNT(DISTINCT channel_id) AS active_channels
FROM the_final_table
WHERE flag_is_active=1
GROUP BY 1,2,3,4
UNION ALL
SELECT start_time, end_time, extension_id, extension_name, SUM(flag_is_active) AS active_extensions, COUNT(DISTINCT channel_id) AS active_channels
FROM the_final_table
WHERE flag_is_active=1
GROUP BY 1,2,3,4

--SELECT * FROM extension_all_activity_log

--
-- SELECT *, SUM(net_activations_per_hour) OVER (ORDER BY the_hour ASC ROWS UNBOUNDED PRECEDING) AS net_activations_cumulative
-- FROM (
-- SELECT eal.*, edl.instances_deactivate, eal.instances_activate - edl.instances_deactivate AS net_activations_per_hour
-- FROM extension_activate_log AS eal
-- LEFT JOIN extension_deactivate_log AS edl ON eal.the_hour = edl.the_hour
-- ORDER BY eal.the_hour ASC
-- )
-- ORDER BY the_hour ASC
