-- by yanghung
-- generate log of data of when a specific user_id oauth'ed with revlo
DROP TABLE IF EXISTS    analysis.panalysis933_oauth_log;
CREATE TABLE    analysis.panalysis933_oauth_log    AS

WITH
oauth_log AS (
  -- There are cases where we have multiple records of the person conducting the oauth, hence the min_time and max_time
  SELECT oa.user_id, oa.client_id, cl.app_name, MIN(oa.time) AS min_time, MAX(oa.time) AS max_time
  FROM logs.oauth_authorize AS oa
  RIGHT JOIN analysis.panalysis879_oauth_client_list AS cl ON oa.client_id=cl.client_id -- only take those client_id records that are in the client_list
  GROUP BY oa.user_id, oa.client_id, cl.app_name
)



SELECT * FROM oauth_log
;
