-- by yanghung
-- generate log of data that joins our oauth logs with revlo provided data
DROP TABLE IF EXISTS    analysis.panalysis933_revlo_oauth_log;
CREATE TABLE    analysis.panalysis933_revlo_oauth_log    AS

WITH
revlo_log AS (
  SELECT * FROM analysis.panalysis933_revlo_log
)
, oauth_log AS (
  SELECT * FROM analysis.panalysis933_oauth_log
)



SELECT revlo_log.user_id, revlo_log.login
, revlo_log.start_date AS revlo_start_date, revlo_log.end_date AS revlo_end_date
, DATE(oauth_log.min_time) AS oauth_start_date, DATE(oauth_log.max_time) AS oauth_end_date
FROM revlo_log
LEFT JOIN oauth_log ON oauth_log.user_id=revlo_log.user_id
;
