-- [from mike engle]
-- Do you have information for # of applications for DS by month since launch of the API?
--
-- applications = # requests for API keys from analysis.sitedb_oauth2_clients
-- active applications = >=5 users requesting oauth to that app from logs.oauth_authorize


WITH
the_timeframe AS (
  SELECT '2015-04-01 00:00:00' AS start_time
)

, app_active AS (
SELECT client_id, MAX(num_users_request_oauth) AS num_users_request_oauth
FROM
(
SELECT DATE(DATE_TRUNC('month', "time")) AS the_month, client_id, COUNT(DISTINCT user_id) AS num_users_request_oauth
FROM logs.oauth_authorize
WHERE
"time" >= (SELECT start_time FROM the_timeframe)
GROUP BY 1,2
)
WHERE num_users_request_oauth>=5
AND the_month>='2017-07-01'
GROUP BY 1
)

SELECT a.*, s.oauth2_client_owner_id AS user_id, s.name as user_name
FROM app_active AS a
LEFT JOIN analysis.sitedb_oauth2_clients AS s ON a.client_id = s.client_id
WHERE s.is_first_party IS FALSE
AND s.oauth2_client_owner_id IS NOT NULL
