package main

import (
	"log"
	"time"
)

// statsdLogger fulfills the statsd.Statter interface, but just logs
// output, doesnt actually write.
type statsdLogger struct {
	// prefix for statsd name
	prefix string
}

func (s *statsdLogger) Close() error { return nil }
func (s *statsdLogger) log(stat string, op string, value interface{}) error {
	log.Printf("%s.%s\t%s\t%v", s.prefix, stat, op, value)
	return nil

}
func (s *statsdLogger) Inc(stat string, value int64, rate float32) error {
	return s.log(stat, "Inc", value)
}
func (s *statsdLogger) Dec(stat string, value int64, rate float32) error {
	return s.log(stat, "Dec", value)
}
func (s *statsdLogger) Gauge(stat string, value int64, rate float32) error {
	return s.log(stat, "Gauge", value)
}
func (s *statsdLogger) GaugeDelta(stat string, value int64, rate float32) error {
	return s.log(stat, "GaugeD", value)
}
func (s *statsdLogger) Timing(stat string, delta int64, rate float32) error {
	return s.log(stat, "Timing", delta)
}
func (s *statsdLogger) TimingDuration(stat string, delta time.Duration, rate float32) error {
	return s.log(stat, "TimingD", delta)
}
func (s *statsdLogger) Set(stat string, value string, rate float32) error {
	return s.log(stat, "Set", value)
}
func (s *statsdLogger) SetInt(stat string, value int64, rate float32) error {
	return s.log(stat, "SetInt", value)
}
func (s *statsdLogger) Raw(stat string, value string, rate float32) error { return nil }

// Sets/Updates the statsd client prefix
func (s *statsdLogger) SetPrefix(prefix string) {
	s.prefix = prefix
}
