# WARNING: DO NOT EDIT, AUTO-GENERATED CODE!
# See https://github.com/jkakar/aws-codegen for more details.

defmodule AWS.CostAndUsageReport do
  @moduledoc """
  All public APIs for AWS Cost and Usage Report service
  """

  @doc """
  Delete a specified report definition
  """
  def delete_report_definition(client, input, options \\ []) do
    request(client, "DeleteReportDefinition", input, options)
  end

  @doc """
  Describe a list of report definitions owned by the account
  """
  def describe_report_definitions(client, input, options \\ []) do
    request(client, "DescribeReportDefinitions", input, options)
  end

  @doc """
  Create a new report definition
  """
  def put_report_definition(client, input, options \\ []) do
    request(client, "PutReportDefinition", input, options)
  end

  @spec request(map(), binary(), map(), list()) ::
    {:ok, Poison.Parser.t | nil, Poison.Response.t} |
    {:error, Poison.Parser.t} |
    {:error, HTTPoison.Error.t}
  defp request(client, action, input, options) do
    client = %{client | service: "cur"}
    host = get_host("cur", client)
    url = get_url(host, client)
    headers = [{"Host", host},
               {"Content-Type", "application/x-amz-json-1.1"},
               {"X-Amz-Target", "AWSOrigamiServiceGatewayService.#{action}"}]
    headers = case client.security_token do
      nil -> headers
      _ -> headers ++ [{"X-Amz-Security-Token", client.security_token}]
    end
    payload = Poison.Encoder.encode(input, [])
    headers = AWS.Request.sign_v4(client, "POST", url, headers, payload)
    case HTTPoison.post(url, payload, headers, options) do
      {:ok, response=%HTTPoison.Response{status_code: 200, body: ""}} ->
        {:ok, nil, response}
      {:ok, response=%HTTPoison.Response{status_code: 200, body: body}} ->
        {:ok, Poison.Parser.parse!(body), response}
      {:ok, _response=%HTTPoison.Response{body: body}} ->
        error = Poison.Parser.parse!(body)
        exception = error["__type"]
        message = error["message"]
        {:error, {exception, message}}
      {:error, %HTTPoison.Error{reason: reason}} ->
        {:error, %HTTPoison.Error{reason: reason}}
    end
  end

  defp get_host(endpoint_prefix, client) do
    if client.region == "local" do
      "localhost"
    else
      "#{endpoint_prefix}.#{client.region}.#{client.endpoint}"
    end
  end

  defp get_url(host, %{:proto => proto, :port => port}) do
    "#{proto}://#{host}:#{port}/"
  end

end
