<?php include_once "header.php" ?>
<?php

if(isset($_POST['btn-submit'])) {
    $startDate = ew_RemoveXSS(ew_StripSlashes($_POST['inputStartDate']));
    $endDate   = ew_RemoveXSS(ew_StripSlashes($_POST['inputEndDate']));   
}


?>

<!-- Select2 -->
<link rel="stylesheet" href="plugins/select2/select2.min.css">
<!-- daterange picker -->
<link rel="stylesheet" href="plugins/daterangepicker/daterangepicker.css">
<!-- datatables button plugin -->
<link rel="stylesheet" href="plugins/datatables/extensions/Buttons-1.2.4/css/buttons.dataTables.min.css">
  
<!-- Full Width Column -->
<div class="content-wrapper">
    <div class="container">
        <!-- Content Header (Page header) -->
        <section class="content-header">
          <h1>
            Aktiviti Logs
            <small>Semakan Aktiviti Logs</small>
          </h1>
          <ol class="breadcrumb">
            <li><a href="index.php"><i class="fa fa-dashboard"></i>Laman Utama</a></li>
            <li>Aktiviti Logs</li>
          </ol>
        </section>    
    
        <!-- Main content -->
        <section class="content">
            <!-- Default box -->
            <div class="box box-danger">
                <div class="box-header with-border">
                  <h3 class="box-title">Search Panel</h3>

                  <div class="box-tools pull-right">
                    <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i></button>
                  </div>
                </div>            
            
            
                <div class="box-body">
                
                    <!-- form start -->
                    <form class="form-horizontal" id="activitylogs-form" action="<?php echo htmlspecialchars(ew_CurrentPage()) ?>" role="form" method="POST">
                    <input type="hidden" name="inputStartDate" id="inputStartDate" value="">
                    <input type="hidden" name="inputEndDate"   id="inputEndDate"   value="">
                    
                    <div class="box-body">
                      <div class="form-group">
                        <label for="inputUserID" class="col-sm-2 control-label">No Tentera</label>

                        <div class="col-sm-3">
                          <input type="text" name="inputUserID" class="form-control" id="inputUserID" placeholder="User ID">
                        </div>
                        
                        <label for="inputActivity" class="col-sm-2 control-label">Activity</label>
                        <div class="col-sm-3">
                          <select name="inputActivity" id="inputActivity" class="form-control select2">
                            <option value="">Select Activity<option>
                            <?php
                            // retrieve WEBUSER table
                            $sql  =  "SELECT *
                                        FROM WEBACTIVITYLOGS_STATUSCODES
                                       ORDER BY STATUS_ID
                                     " 
                                    . $where;
                            $stmt = $DB_con->prepare($sql, array(PDO::ATTR_CURSOR => PDO::CURSOR_SCROLL));
                            $stmt->execute();
                            while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {                              
                            ?>
                            <option value="<?php echo $row['STATUS_ID'];?>"><?php echo $row['STATUS_DESC'];?></option>
                            <?php
                            }
                            ?>
                          </select>
                          <div type="hidden" name="inputActivity2" id="inputActivity2"></div>
                        </div>
                        <div class="col-sm-2">
                        </div>
                        
                      </div>
                      
                      <!-- Date and time range -->
                      <div class="form-group">
                        <label for="daterange-btn" class="col-sm-2 control-label">Report Date:</label>

                        <div class="col-sm-3">
                          <button type="button" class="btn btn-default pull-left" id="daterange-btn">
                            <span>
                              <i class="fa fa-calendar"></i> Date range picker
                            </span>
                            <i class="fa fa-caret-down"></i>
                          </button>
                        </div>
                      </div>
                      <!-- /.form group -->
                      
                    </div>
                    <!-- /.box-body -->
                    <div class="box-footer">
                      <button type="button" name="btn-submit" id="btn-submit" class="btn btn-info pull-right">Search</button>
                    </div>
                    <!-- /.box-footer -->
                    </form>                
                
                
                </div>   
                <!-- /.box-body -->
            </div>
            <!-- /.box -->
            
            
            
            
            <!-- Default box -->
            <div class="box box-primary">
            
                <div class="box-body">
                    <table id="activitylogs" class="table table-striped table-bordered table-hover display responsive nowrap"  width="100%" cellspacing="0">
                      <thead>
                        <tr>
                          <th>No Tentera</th>
                          <th>Aktiviti</th>
                          <th>Remark</th>
                          <th>Tarikh Aktivity</th>
                        </tr>
                      </thead>
                      <tfoot>
                        <tr>
                          <th>No Tentera</th>
                          <th>Aktiviti</th>
                          <th>Remark</th>
                          <th>Tarikh Aktivity</th>
                        </tr>
                      </tfoot>
                    </table>                
                
                </div>   
                <!-- /.box-body -->
            </div>
            <!-- /.box -->
            
        </section>
        <!-- /.content -->
    </div>
    <!-- /.container -->
</div>
<!-- /.content-wrapper -->                

<?php include_once "footer.php" ?>

<!-- Select2 -->
<script src="plugins/select2/select2.full.min.js"></script>
<!-- date-range-picker -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.11.2/moment.min.js"></script>
<script src="plugins/daterangepicker/daterangepicker.js"></script>
<!-- datatables button plugin -->
<script src="plugins/datatables/extensions/Buttons-1.2.4/js/dataTables.buttons.min.js"></script>
<script src="plugins/datatables/extensions/Buttons-1.2.4/js/buttons.print.min.js"></script>
<script src="plugins/datatables/extensions/Buttons-1.2.4/js/buttons.html5.js"></script> 
<script src="plugins/datatables/extensions/Buttons-1.2.4/js/buttons.flash.js"></script> 



<script>
  $(function () {
    //Initialize Select2 Elements
    $(".select2").select2({
        placeholder: "Select Activity",
        allowClear: true      
    });
    
    var start = moment();
    var end   = moment();
    
    function cb(start, end) {
        $('#daterange-btn span').html(start.format('YYYY-MM-DD') + ' - ' + end.format('YYYY-MM-DD'));
        $('#inputStartDate').val(start.format('YYYY-MM-DD'));
        $('#inputEndDate').val(end.format('YYYY-MM-DD'));
    }    
    
    //Date range as a button
    $('#daterange-btn').daterangepicker(
        {
          startDate: start,
          endDate:   end,          
          ranges: {
            'Today': [moment(), moment()],
            'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
            'Last 7 Days': [moment().subtract(6, 'days'), moment()],
            'This Month': [moment().startOf('month'), moment().endOf('month')],
            'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
          }
        },
        cb
    );
    
    cb(start, end);
    
    //alert();
    
    $('#daterange-btn').on('show.daterangepicker', function(ev, picker) {
        $('#inputStartDate').val(picker.startDate.format('YYYY-MM-DD'));
        $('#inputEndDate').val(picker.endDate.format('YYYY-MM-DD'));
        //alert(picker.startDate.format('YYYY-MM-DD'));
        //console.log(picker.startDate.format('YYYY-MM-DD'));
        //console.log(picker.endDate.format('YYYY-MM-DD'));
    });    
    
    
  });
</script>    
<script type="text/javascript" language="javascript" >
    $(document).ready(function() {
    //$(function () {
      
        $(window).keydown(function(event){
          if(event.keyCode == 13) {
            event.preventDefault();
            return false;
          }
        });     

     
        jQuery.fn.DataTable.Api.register( 'buttons.exportData()', function ( options ) {
                if ( this.context.length ) {
                    var jsonResult = $.ajax({
                        url:      'ajax_activitylogs.php',
                        type:     'post',
                        dataType: 'json', // this bit here
                        data:     {
                                     userID   : $('#inputUserID').val(),
                                     activity : $('#inputActivity').val(),
                                     dtFrom   : $('#inputStartDate').val(),
                                     dtTo     : $('#inputEndDate').val(),
                                     allPage  : 'ALL'
                                  },
                            
                        success:  function (result) {
                                      //Do nothing

                                  },
                        async:    false
                    });
                    
                    
                    
                    return {body: jsonResult.responseJSON.data , header: $("#activitylogs thead tr th").map(function() { return this.innerHTML; }).get()};
                }
        });
        
        var today = new Date();
        var date = today.getFullYear()+'-'+(today.getMonth()+1)+'-'+today.getDate();
        var time = today.getHours() + ":" + today.getMinutes() + ":" + today.getSeconds();
        var dateTime = date+' '+time;
        
        var dataTable = $('#activitylogs').DataTable( {
            "processing": true,
            "serverSide": true,
            "lengthMenu": [ 5, 10, 25, 50 ],
            "dom": "<'row'<'col-sm-6'l><'col-sm-6'<'box-tools pull-right'<'has-feedback'B>>>><'row'<'col-sm-12't>><'row'<'col-sm-5'i><'col-sm-7'p>>",
            //"dom": 'Bfrtip',
            "buttons": [
                        {
                            extend: 'print',
                            text: 'Print',
                            //message: '<strong>Aktiviti Logs <div class="pull-right">Report Date: '+dateTime+"</div></strong>",
                            message: function () {
                                        return $('#inputActivity').select2('data')[0].text;
                                     },
                            autoPrint: false,
                            exportOptions: {
                                modifier: {
                                    page: 'all'
                                }
                            },
                            customize: function ( win ) {
                                
                                $(win.document.body)
                                    .css( 'font-size', '10pt' );
                                    //.prepend(
                                    //    '<img src="http://datatables.net/media/images/logo-fade.png" style="position:absolute; top:0; left:0;" />'
                                    //);
                                $(win.document.body).find( 'table' )
                                    .addClass( 'compact' )
                                    .css( 'font-size', 'inherit' );
                                $(win.document.body).find('h1')
                                    .css('text-align','center');
                                $(win.document.body).find('strong')
                                    .css( 'font-size', '15pt' );
                            }
                        },
                        {
                            extend: 'excel',
                            message: 'Aktiviti Logs'                                                        
                          
                        }
                       ],
            //"sDom": "<'row'<'col-sm-6'l><'col-sm-6'<'box-tools pull-right'<'has-feedback'f>>>><'row'<'col-sm-12't>><'row'<'col-sm-5'i><'col-sm-7'p>>",
            "ajax":{
                url :"ajax_activitylogs.php", // json datasource
                type: "post",  // method  , by default get
                data: function(d) {
                          d.userID   = $('#inputUserID').val();
                          d.activity = $('#inputActivity').val();
                          d.dtFrom   = $('#inputStartDate').val();
                          d.dtTo     = $('#inputEndDate').val();
                      },
                error: function(){  // error handling
                    alert("Opps.. There's an error! Couldn't retrieve data at the moment..");
 
                }
            },
            "order": ([3, 'asc']),
        });        
        
        $('#btn-submit').click(function() {
            $userID   = $('#inputUserID').val();
            $activity = $('#inputActivity').val();
            $dtFrom   = $('#inputStartDate').val();
            $dtTo     = $('#inputEndDate').val();
            
            dataTable.ajax.data = function(d) {
                d.userID   = $userID;
                d.activity = $activity;
                d.dtFrom   = $dtFrom;
                d.dtTo     = $dtTo;
            };

            dataTable.ajax.reload();
        });
        
        // change onchange
        // var $inputActivity = $('#inputActivity');
        // var reporttype     = $inputActivity.select2('data')[0].text;
        // $inputActivity.on("select2:select", function (e) { 
                                                // //$('#inputActivity').trigger('change.select2');
                                                // //alert("hell yeah!");                                                
                                                // var reporttype     = $inputActivity.select2('data')[0].text;                                                

                                                // new $.fn.dataTable.Buttons( dataTable, {
                                                                              // buttons: [
                                                                                  // 'print',
                                                                                  // { extend: 'print', message: reporttype }
                                                                              // ]
                                                                          // } );
                                                    // dataTable.buttons( 0, null ).remove();
                                                    // dataTable.buttons( 0, null ).container().prependTo(
                                                    // dataTable.table().container()
                                                // );
                                                
                                            // });
        
        
        //alert(reporttype);  
        
        
    });
    
    
</script>