<?php include_once "header.php" ?>

<?php
if (!isset($conn)) $conn = ew_Connect();

if(isset($_POST['btn-submit'])) {
    $password            = ew_RemoveXSS(ew_StripSlashes($_POST['inputPasswordOld'       ]));
    $passwordnew         = ew_RemoveXSS(ew_StripSlashes($_POST['inputPasswordNew'       ]));
    $passwordnewconfirm  = ew_RemoveXSS(ew_StripSlashes($_POST['inputPasswordNewConfirm']));

    /*
    $oldpwd    = ew_RemoveXSS(ew_StripSlashes($_POST['oldpassword'    ]));
    $newpwd    = ew_RemoveXSS(ew_StripSlashes($_POST['newpassword'    ]));
    $cfmnewpwd = ew_RemoveXSS(ew_StripSlashes($_POST['confirmpassword']));
    */
    if (!empty($password) or !empty($passwordnew) or !empty($passwordnewconfirm)){
        if (empty($password)){
            $errorMsg = "Old password is empty";
        } else if (empty($passwordnew)){
            $errorMsg = "New Password is empty";
        } else if (empty($passwordnewconfirm)){
            $errorMsg = "Confirm New Password is empty";
        } else if ($password == $passwordnew){
            $errorMsg = "Old Password and New Password is the same";
        } else if ($passwordnew !== $passwordnewconfirm){
            $errorMsg = "New Password and Confirm New Password not matched!";
        }          
    }   
    
    if (empty($errorMsg)){
        $passwordnew = password_hash($passwordnew, PASSWORD_DEFAULT); //encrypt password
      
        // UPDATE WEBUSER TABLE
        $stmt = $DB_con->prepare("UPDATE WEBUSER
                                     SET  USERPASSWORD =:upassword
                                         ,DATEMODIFIED = getdate()                                     
                                   WHERE USERID=:uid
                                 ");
        $stmt->bindparam(":uid",       $user_id);
        $stmt->bindparam(":upassword", $passwordnew);
        $stmt->execute();
        
        $errors="<div class=\"alert alert-success alert-dismissable\" id=\"success-alert\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\">x</button>Update Success</div>";
        header("location: profile.php?success=1");
    } else {
        $errors="<div class=\"alert alert-danger alert-dismissable\" id=\"fail-alert\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\">x</button>Update Error! $errorMsg</div>";
    }
}


?>

<!-- Full Width Column -->
<div class="content-wrapper">
    <div class="container">
        <!-- Content Header (Page header) -->
        <section class="content-header">
          <h1>
            User Profile
            <small>Update User Profile</small>
          </h1>
          <ol class="breadcrumb">
            <li><a href="#"><i class="fa fa-dashboard"></i class="active">Home</a></li>
            <li>Profile</li>
          </ol>
        </section>    
    
        <!-- Main content -->
        <section class="content">

          <div class="row">
            <div class="col-md-3">

              <!-- Profile Image -->
              <div class="box box-primary">
                <div class="box-body box-profile">
                  <img class="profile-user-img img-responsive img-circle" src="dist/img/soldier.png" alt="User profile picture">

                  <h3 class="profile-username text-center"><?php echo $_SESSION['user_name']; ?></h3>

                  <p class="text-muted text-center"><?php echo $user_id; ?></p>

                  <ul class="list-group list-group-unbordered">
                    <li class="list-group-item">
                      <b>Member since:</b> <a class="pull-right"><?php echo date("d M Y", strtotime($_SESSION['date_created'])); ?></a>
                    </li>
                  </ul>
                  <a href="profile.php" class="btn btn-primary btn-block"><b>Back</b></a>
                </div>
                <!-- /.box-body -->
              </div>
              <!-- /.box -->
              
            </div>
            <!-- /.col -->
            <div class="col-md-9">
              <div class="nav-tabs-custom">
                <ul class="nav nav-tabs">
                  <li class="active"><a href="#settings" data-toggle="tab">Change Password</a></li>
                </ul>
                <div class="tab-content">
                  <div class=" active tab-pane" id="settings">
                    <form class="form-horizontal" id="profile-form" action="<?php echo htmlspecialchars(ew_CurrentPage()) ?>" data-toggle="validator" role="form" method="POST" remote="true">
                      <div id="error">
                            <!-- error will be showen here ! -->  
                        <?php echo $errors; ?>                            
                      </div>
                      <div class="form-group">
                        <label for="inputPasswordOld" class="col-sm-3 control-label">Old Password</label>

                        <div class="col-sm-9">
                          <input type="password" name="inputPasswordOld" class="form-control" id="inputPasswordOld" placeholder="Old Password" value="<?php echo $password;?>" required>
                        </div>
                      </div>
                      <div class="form-group">
                        <label for="inputPasswordNew" class="col-sm-3 control-label">New Password</label>

                        <div class="col-sm-9">
                          <input type="password" name="inputPasswordNew" data-minlength="6" class="form-control" id="inputPasswordNew" placeholder="New Password" pattern="(?=^.{6,}$)((?=.*\d)|(?=.*\W+))(?![.\n])(?=.*[A-Z])(?=.*[a-z]).*$" data-error="Min 6 characters, with combination of 6 alphabets of uppercase/lowercase, a number, and a symbol!" value="<?php echo $passwordnew;?>" required>
                          <span class="help-block with-errors"></span>
                        </div>
                      </div>
                      <div class="form-group">
                        <label for="inputPasswordNewConfirm" class="col-sm-3 control-label">Confirm New Password</label>

                        <div class="col-sm-9">
                          <input type="password" name="inputPasswordNewConfirm" data-minlength="6" data-match="#inputPasswordNew" class="form-control" id="inputPasswordNewConfirm" placeholder="Confirm New Password"  data-error="Password not matched!" value="<?php echo $passwordnewconfirm;?>" required>
                          <span class="help-block with-errors"></span>
                          
                        </div>
                      </div>
                      <div class="form-group">
                        <div class="col-sm-offset-3 col-sm-9">
                          <button type="submit" name="btn-submit" class="btn btn-danger">Submit</button>
                          <a href="profile.php" class="btn btn-info">Cancel</a>
                        </div>
                      </div>
                    </form>
                  </div>
                  <!-- /.tab-pane -->
                </div>
                <!-- /.tab-content -->
              </div>
              <!-- /.nav-tabs-custom -->
            </div>
            <!-- /.col -->
          </div>
          <!-- /.row -->

        </section>
        <!-- /.content -->

    </div>
    <!-- /.container -->
</div>
<!-- /.content-wrapper -->

<?php include_once "footer.php" ?>
<script>
    // close the success message
    $(document).ready (function(){
        $("#success-alert").fadeTo(2000, 1000).slideUp(1000, function(){
            $("#success-alert").alert('close');
        });
        $("#fail-alert").fadeTo(2000, 1000).slideUp(1000, function(){
            $("#fail-alert").alert('close');
        });
    });
</script>