<?php include_once "header.php" ?>
<?php

$error = ew_RemoveXSS(ew_StripSlashes($_GET['success']));

if ($error=='1'){
    $error = "<div class=\"alert alert-success alert-dismissable\" id=\"success-alert\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\">x</button>Update Success</div>";
}


?>

<!-- Full Width Column -->
<div class="content-wrapper">
    <div class="container">
        <!-- Content Header (Page header) -->
        <section class="content-header">
          <h1>
            Akaun Ahli
            <small>Pengurusan Akaun Ahli</small>
          </h1>
          <ol class="breadcrumb">
            <li><a href="#"><i class="fa fa-dashboard"></i class="active">Laman Utama</a></li>
            <li>Akaun Ahli</li>
          </ol>
        </section>    
    
        <!-- Main content -->
        <section class="content">
            <!-- Default box -->
            <div class="box box-primary">
                <div class="box-header">
                  <div id="error">
                  <?php echo $error; ?>
                  </div>
                  <div class="row">
                    <div class="col-md-2 pull-right">
                      <a href="useraccount-add.php" class="btn btn-primary btn-block">Add User</a>
                    </div>
                  </div>
                </div>
                <div class="box-body">
                
                
                <table id="useraccount" class="table table-striped table-bordered table-hover display responsive nowrap"  width="100%" cellspacing="0">
                  <thead>
                    <tr>
                      <th></th>
                      <th>User ID</th>
                      <th>Nama</th>
                      <th>Emel</th>
                      <th>User Level</th>
                      <th>Aktif</th>
                    </tr>
                  </thead>
                  <tfoot>
                    <tr>
                      <th></th>
                      <th>User ID</th>
                      <th>Nama</th>
                      <th>Emel</th>
                      <th>User Level</th>
                      <th>Aktif</th>
                    </tr>
                  </tfoot>
                </table>
                
                </div>   
                <!-- /.box-body -->
            </div>
            <!-- /.box -->
        </section>
        <!-- /.content -->
    </div>
    <!-- /.container -->
</div>
<!-- /.content-wrapper -->


<!-- MODAL DELETE POPUP -->
<div class="modal modal-info" id="confirm-delete" role="dialog" data-backdrop="static" data-keyboard="false" aria-labelledby="myModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-sm">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title">Confirm Delete</h4>
      </div>
      <div class="modal-body">
          <p>Rekod ini akan dilupuskan.</p>
          <p>Teruskan?</p>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-outline pull-left" data-dismiss="modal">Close</button>
        <button type="button" class="btn btn-outline btn-ok">Delete</button>
      </div>
    </div>
    <!-- /.modal-content -->
  </div>
  <!-- /.modal-dialog -->
</div>
<!-- MODAL DELETE POPUP -->



<?php include_once "footer.php" ?>
<script type="text/javascript" language="javascript" >
    $(document).ready(function() {
        var dataTable = $('#useraccount').DataTable( {
            "processing": true,
            "serverSide": true,
            "lengthMenu": [ 5, 10, 25, 50 ],
            "ajax":{
                url :"ajax_useraccount.php", // json datasource
                type: "post",  // method  , by default get
                error: function(){  // error handling
                    alert("Opps.. There's an error! Couldn't retrieve data at the moment..");
 
                }
            },
            "columnDefs":[
                          {"targets": 0,
                           "sortable": false,
                           "width": 30,
                           "data": null,
                           "render": function ( data, type, full, meta ) {
                             return "<div class='btn-group'><button class='btn btn-xs btn-danger' data-toggle='modal' data-target='#confirm-delete'><span class='glyphicon glyphicon-trash'></span></button>&nbsp;<a href='useraccount-edit.php?userid="+data[0]+"' class='btn btn-xs btn-danger'><span class='glyphicon glyphicon-edit'></span></button></div>";
                           }                             
                           //"defaultContent": "<div class='btn-group'><button class='btn btn-xs btn-danger' data-toggle='modal' data-target='#confirm-delete'><span class='glyphicon glyphicon-trash'></span></button>&nbsp;<a href='useraccount-edit.php' class='btn btn-xs btn-danger'><span class='glyphicon glyphicon-edit'></span></button></div>"

                          }
                         ]
        });
        
        // auto-hide success msg
        $("#success-alert").fadeTo(2000, 1000).slideUp(1000, function(){
            $("#success-alert").alert('close');
        });
        
        // retrieve the user id of the row click and pass the variable "userID"
        $('#useraccount tbody').on('click', 'button', function(e) {
            data = dataTable.row( $(this).parents('tr') ).data();
            userID = data[1];
        });
        
        // process ajax calls passing variable "userID" above to delete
        // on success: reload datatable, display success alert and auto-hide it
        $('#confirm-delete').on('click', '.btn-ok', function(e) {
            $.ajax({
                  type: 'POST',
                  url: 'ajax_useraccount_deletesubmit.php',
                  data: {userid: userID},
                  success: function(html) {
                      dataTable.ajax.reload();
                      $('#confirm-delete').modal('hide');
                      $("#error").html("<div class=\"alert alert-success alert-dismissable\" id=\"success-alert\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\">x</button>Delete Success</div>");
                      $("#success-alert").fadeTo(2000, 1000).slideUp(1000, function(){
                          $("#success-alert").alert('close');
                      
                      });
                  }
            });
            //alert(userID);
        });
        
    });
    
    
</script>
