<?php
require_once 'db.php';
include_once "ewcfg12.php";
include_once ((EW_USE_ADODB) ? "adodb5/adodb.inc.php" : "ewmysql12.php");
include_once "phpfn12.php";
include_once "class.user.php";


if(isset($_GET['id']) && !empty($_GET['id']) AND isset($_GET['email']) && !empty($_GET['email']) AND isset($_GET['hash']) && !empty($_GET['hash'])){
    // Verify data
    $id    = trim(ew_RemoveXSS(ew_StripSlashes($_GET['id'])));
    $email = trim(ew_RemoveXSS(ew_StripSlashes($_GET['email'])));
    $hash  = trim(ew_RemoveXSS(ew_StripSlashes($_GET['hash'])));

    try
    {
        // check first if record exists
        $query = "SELECT USERID, USEREMAIL, USERACTIVATIONPIN, USERACTIVATIONPINUSEDBY, ACTIVATED FROM WEBUSER WHERE USERID=:uid AND USEREMAIL=:umail AND USERACTIVATIONPIN=:upin AND ACTIVATED = 0 AND getdate() <= USERACTIVATIONPINUSEDBY";
        $stmt = $DB_con->prepare( $query, array(PDO::ATTR_CURSOR => PDO::CURSOR_SCROLL));
        $stmt->bindparam(":uid",   $id);
        $stmt->bindparam(":umail", $email);
        $stmt->bindparam(":upin",  $hash);
        $stmt->execute();
        $num = $stmt->rowCount();

        if($num > 0)
        {
            // update the 'verified' field, from 0 to 1 (unverified to verified)
            $query = "UPDATE WEBUSER
                         SET ACTIVATED    = 1,
                             DATEMODIFIED = getdate()
                       WHERE USERID           =:uid
                         AND USEREMAIL        =:umail
                         AND USERACTIVATIONPIN=:upin
                     ";
            $stmt2 = $DB_con->prepare($query);
            $stmt2->bindparam(":uid",   $id);
            $stmt2->bindparam(":umail", $email);
            $stmt2->bindparam(":upin",  $hash);
            if($stmt2->execute()){
                // tell the user
                //$error[] = "<div>Your account has been activated, you can now login.</div>";
                $errorMsg = "Akaun anda telah diaktifkan. Kembali ke laman i-Wira untuk log masuk";
            }else{
                //$error[] = "<div>The url is either invalid or you already have activated your account.</div>";
                $errorMsg = "URL yang diklik tidah sah atau anda telah mengaktifkan akaun anda.";
                //print_r($stmt->errorInfo());
            }

        } else {
            // tell the user he should not be in this page
            $errorMsg = "Kod Pengaktifan tidak sah atau tidak dijumpai. Sila hubungi Admin.";
        }

     }
     catch(PDOException $e)
     {
        $errorMsg = $e->getMessage();
     }
}else{
    // Invalid approach
    //echo '<div class="statusmsg">Invalid approach, please use the link that has been send to your email.</div>';
    $errorMsg = 'Kod pengaktifan tidak sah. Sila guna link yang diberikan di dalam emel anda.';
}

?>


<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <!-- This file has been downloaded from Bootsnipp.com. Enjoy! -->
    <title>i-Wira - Sistem Semakan Caruman Atas Talian</title>
    <!-- Tell the browser to be responsive to screen width -->
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <!-- Bootstrap 3.3.6 -->
    <link rel="stylesheet" href="bootstrap/css/bootstrap.min.css">
    <!--<link href="http://maxcdn.bootstrapcdn.com/bootstrap/3.3.0/css/bootstrap.min.css" rel="stylesheet">-->
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.5.0/css/font-awesome.min.css">
    <link rel="stylesheet" href="dist/css/AdminLTE.min.css">
    <link rel="stylesheet" href="dist/css/skins/skin-blue.min.css">

    <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
    <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
    <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
    <![endif]-->  

    <style type="text/css">
        .example-modal .modal {
          position: relative;
          top: auto;
          bottom: auto;
          right: auto;
          left: auto;
          display: block;
          z-index: 1;
        }

        .example-modal .modal {
          background: transparent !important;
        }
        
          .footer {
            position: absolute;
            bottom: 0;
            width: 100%;
            /* Set the fixed height of the footer here */
            height: 40px;
            background-color: #f5f5f5;
          }       
        
        .container {
          width: auto;
          max-width: 680px;
          padding: 0 15px;
        }
        .container .text-muted {
          margin: 20px 0;
        }        
    </style>

</head>
<body>

<div class="container">
    <div class="row">
      <br>
      <img class="img-responsive hidden-lg hidden-md center-block" src="dist/img/LTATLogo3.png">
      <img class="img-responsive hidden-sm hidden-xs center-block" src="dist/img/logo_ltat_587x70.png"><br>
      <h1 class="text-center">      
      i-Wira<br>      
      <small>Sistem Semakan Caruman Atas Talian</small>
      </h1>
      
      <div class="example-modal">
        <div class="modal modal-danger">
          <div class="modal-dialog">
            <div class="modal-content">
              <div class="modal-header">
                <h4 class="modal-title">Pengaktifan i-Wira</h4>
              </div>
              <div class="modal-body">
                <p><?php echo $errorMsg;?></p>
              </div>
              <div class="modal-footer">
                  <!--<button type="button" class="btn btn-outline pull-left" data-dismiss="modal">Close</button>-->
                  <a href="login.php" class="btn btn-outline">Log Masuk Semula</a>
              </div>
            </div>
            <!-- /.modal-content -->
          </div>
          <!-- /.modal-dialog -->
        </div>
        <!-- /.modal -->
      </div>
      <!-- /.example-modal -->      
      
    </div>
</div>

  <footer class="footer">
      <p>
      <div class="container">
        <div class="pull-right hidden-xs">
          <b>Versi</b> 1.1.0
        </div>
        <div class="pull-left"><strong>&copy; 2017 <a href="http://www.ltat.org.my">Lembaga Tabung Angkatan Tentera</a>.</strong></div><div class="pull-left hidden-xs">&nbsp;Hak Cipta Terpelihara.</div>
      </div>

  </footer>
  
<!-- jQuery 2.2.3 -->
<script src="plugins/jQuery/jquery-2.2.3.min.js"></script>
<!-- Bootstrap 3.3.6 -->
<script src="bootstrap/js/bootstrap.min.js"></script>
<!-- AdminLTE App -->
<script src="dist/js/app.min.js"></script>

</body>
</html>
