<?php
require_once 'db.php';
include_once "ewcfg12.php";
include_once ((EW_USE_ADODB) ? "adodb5/adodb.inc.php" : "ewmysql12.php");
include_once "phpfn12.php";
include_once "class.usertest.php";

// grab recaptcha library
require_once "phpinc/recaptchalib.php";

$secretKey   = '6LfM3yUTAAAAAIN9C0U154G3M04Gxb76YdWtsI_4';
$response    = false;

$loginError      = false;
$registerError   = false;
$registerOk      = false;
$lostpwdError    = false;
$lostpwdOk       = false;
$resendactivation = "";

$user = new USER($DB_con);


if($_SERVER['REQUEST_METHOD'] == 'POST'){
  //if(!empty($_POST['g-recaptcha-response'])){
  //  $objRecaptcha = new ReCaptcha($secretKey);
  //  $response = $objRecaptcha->verifyResponse($_SERVER['REMOTE_ADDR'], $_POST['g-recaptcha-response']);
  //}
  //if(isset($response->success) && 1 == $response->success){
    //Human is detected you can write script to perform actual action
      if(isset($_POST['btn-login'])) {
          ///////////////////////////
          /// LOGIN CHECK
          //////////////////////////
          $uname = ew_RemoveXSS(ew_StripSlashes($_POST['armyno']));
          $upass = ew_RemoveXSS(ew_StripSlashes($_POST['userpassword']));
          if($user->login($uname,$upass)) {
              $user->log($uname, 1, "");
              if ($_SESSION[EW_SESSION_SYS_ADMIN] == 1 || $_SESSION[EW_SESSION_USER_LEVEL]==-1 || $_SESSION[EW_SESSION_USER_LEVEL]==-2){
                $user->redirect('dashboard.php');
              } else {
                $user->redirect('index.php');
              }
          } else {
             $loginError = true;
             $errorMsg   = "Invalid login credential";
             $user->log($uname, 2, $errorMsg);
          }
      } else if(isset($_POST['btn-register'])) {
          ///////////////////////////
          /// REGISTRATION CHECK
          //////////////////////////
          $uname  = trim(ew_RemoveXSS(ew_StripSlashes($_POST['armyno'])));
          $umail  = trim(ew_RemoveXSS(ew_StripSlashes($_POST['useremail'])));
          $usecure= trim(ew_RemoveXSS(ew_StripSlashes($_POST['secureword'])));
          $upass  = trim(ew_RemoveXSS(ew_StripSlashes($_POST['userpassword']))); 
          $upass2 = trim(ew_RemoveXSS(ew_StripSlashes($_POST['userpasswordconfirm']))); 
          $fname  = "";
          $lname  = "";
        
          if($uname=="") {
              $registerError = true;
              $errorMsg      = "Sila isi No Tentera."; 
          }
          else if($umail=="") {
              $registerError = true;
              $errorMsg      = "Sila isikan alamat Emel."; 
          }
          else if(!filter_var($umail, FILTER_VALIDATE_EMAIL)) {
              $registerError = true;
              $errorMsg      = "Sila isikan alamat emel yang sah.";
          }
          else if ($usecure==""){
              $registerError = true;
              $errorMsg      = "Sila isikan SecureWord. SecureWord mesti dalam 5-6 karektor.";
          }
          else if($upass=="") {
              $registerError = true;
              $errorMsg      = "Sila isikan kata laluan";
          }
          else if($upass!==$upass2) {
              $registerError = true;
              $errorMsg      = "Kata laluan tidak sama.";
          }
          else if(strlen($upass) < 6){
              $registerError = true;
              $errorMsg      = "Min 6 karektor untuk kata laluan."; 
          }
          else
          {
             try
             {
                $stmt = $DB_con->prepare("SELECT USERID,USEREMAIL FROM WEBUSER WHERE USERID=:uname OR USEREMAIL=:umail");
                $stmt->execute(array(':uname'=>$uname, ':umail'=>$umail));
                $row=$stmt->fetch(PDO::FETCH_ASSOC);
           
                if($row['USERID']==$uname) {
                    $registerError = true;
                    $errorMsg      = "No Tentera telah didaftar.";
                    $user->log($uname, 5, $errorMsg);
                }
                else if($row['USEREMAIL']==$umail) {
                    $registerError = true;
                    $errorMsg      = "Alamat emel telah didaftar.";
                    $user->log($uname, 5, $errorMsg);
                }
                else
                {
                    $stmt2 = $DB_con->prepare("DECLARE @uname varchar(10) SET @uname=:uname SELECT top 1 ArmyNo FROM VIEW_INDUKTAULIAH_MASTER WHERE LEFT(ArmyNo,7)=(SELECT CASE WHEN LEN(@uname) > 7 THEN @uname ELSE RIGHT ('0000000'+ CAST (@uname AS varchar), 7) END)", array(PDO::ATTR_CURSOR => PDO::CURSOR_SCROLL));
                    $stmt2->execute(array(':uname'=>$uname));
                    $userRow=$stmt2->fetchAll(PDO::FETCH_ASSOC);
                    //die($stmt2->rowCount());
                    if(count($userRow) == 0)
                    {
                        $registerError = true;
                        $errorMsg      = "No Tentera tidak sah.";
                        $user->log($uname, 5, $errorMsg);
                    }
                    else
                    {
                        $stmt3 = $DB_con->prepare("SELECT top 1 IsNull(NAME, '') AS FNAME FROM TBMILITARIES WHERE MILITARYID=:uid");
                        $stmt3->execute(array(':uid'=>$uname));
                        $row3  = $stmt3->fetch(PDO::FETCH_ASSOC);
                        $fname = $row3['FNAME'];
                        
                        // name is empty, check from statement table
                        if ($fname==""){
                          $stmt4 = $DB_con->prepare("DECLARE @uname varchar(10) SET @uname=:uid SET @uname=RIGHT('0000000'+ CAST (@uname AS varchar),7) SELECT top 1 PersonnelName FROM [dbo].[LTAT_tbl_statementcurrent] WHERE LEFT(PersonnelID,7)=@uname");
                          $stmt4->execute(array(':uid'=>$uname));
                          $row4  = $stmt4->fetch(PDO::FETCH_ASSOC);
                          $fname = $row4['PersonnelName'];                          
                        }
                     
                        if($user->registernew($fname,$lname,$uname,$umail,$usecure,$upass)) 
                        {
                            $user->log($uname, 4, "");
                            $user->sendactivation($uname,$upass,$umail);
                            $registerError = true;  // set to true to display msg
                            $registerOk    = true;  // set to true to change msg to ok green
                            //$errorMsg      = "Success. Check email for activation";
                            $errorMsg      = "Pendaftaran berjaya. Sila semak emel untuk pengaktifan akaun i-Wira";
                            $resendactivation = "<div class=''>Jika anda tidak menerima e-mel dalam masa 5 minit, sila periksa mel 'junk/spam' atau klik di sini untuk <strong><a id='btnResendActivation' class='btn btn-success btn-xs' style='text-decoration: none'>memohon penghantaran</a></strong> semula e-mel pengaktifan</div>";
                            //$user->redirect('register.php?joined');
                        }
                    }
                }
            }
            catch(PDOException $e)
            {
                $registerError = true;
                $errorMsg      = $e->getMessage();
                $user->log($uname, 5, $errorMsg);
            }
         }
      } else if(isset($_POST['btn-forgotpwd'])) {
          ///////////////////////////
          /// FORGOT PASSWORD CHECK
          //////////////////////////
          
          if(!empty($_POST['g-recaptcha-response'])){
            $objRecaptcha = new ReCaptcha($secretKey);
            $response = $objRecaptcha->verifyResponse($_SERVER['REMOTE_ADDR'], $_POST['g-recaptcha-response']);
          }
          if(isset($response->success) && 1 == $response->success){
            //Human is detected you can write script to perform actual action          
              $uname  = trim(ew_RemoveXSS(ew_StripSlashes($_POST['armyno'])));

              if($uname=="") {
                  $lostpwdError = true;
                  $errorMsg     = "No Tentera mesti diisikan!";
              } else {
                  try
                  {
                      $stmt = $DB_con->prepare("SELECT USERID,USEREMAIL FROM WEBUSER WHERE USERID=:uname");
                      $stmt->execute(array(':uname'=>$uname));
                      $row=$stmt->fetch(PDO::FETCH_ASSOC); 

                      if($row['USERID']==$uname) {
                          $user->log($uname, 15, "");
                          $user->sendforgotpassword($uname);
                          //$user->redirect('forgotpwd.php?joined');
                          $lostpwdError = true;  // set to true to display msg
                          $lostpwdOk    = true;  // set to true to change msg to ok green
                          $errorMsg     = "Sila semak emel anda untuk menetap kata laluan semula";
                          
                      } else {
                          $lostpwdError = true;
                          $errorMsg     = "No Tentera tidak sah.";                  
                      }
                  } catch(PDOException $e) {
                      $lostpwdError = true;
                      $errorMsg     = $e->getMessage();
                  }
              }
          } else {
            $lostpwdError = true;
            $errorMsg     = "Pengesahan Captcha gagal!";
          }
      }
      
  //} else {
  //  $loginError = true;
  //  $errorMsg   = "You are not human!";
  //}
}

?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <!-- This file has been downloaded from Bootsnipp.com. Enjoy! -->
    <title>i-Wira - Sistem Semakan Caruman Atas Talian</title>
    <!-- Tell the browser to be responsive to screen width -->
	<meta name="description" content="Portal i-Wira:Sistem Semakan Caruman Atas Talian,iwira.ltat.org.my">
  <meta name="keywords" content="iwira,IWIRA,ltat,LTAT,i-Wira,Semak Penyata LTAT,Penyata Atas Talian,Semak Waris Semasa,Semak Saham Amanah Affin Hwang, Semak Sejarah Pengeluaran,Aduan,Cadangan dan Pertanyaan,Daftar iwira, Daftar i-Wira">
  <meta name="author" content="Unit Teknologi Maklumat,Lembaga Tabung Angkatan Tentera">
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <!-- Bootstrap 3.3.6 -->
    <link rel="stylesheet" href="bootstrap/css/bootstrap.min.css">
    <!--<link href="http://maxcdn.bootstrapcdn.com/bootstrap/3.3.0/css/bootstrap.min.css" rel="stylesheet">-->
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.5.0/css/font-awesome.min.css">
    <link rel="stylesheet" href="dist/css/AdminLTE.min.css">
    <link rel="stylesheet" href="dist/css/skins/skin-blue.min.css">
    <link rel="stylesheet" href="plugins/jQueryUI/jquery-ui.css">

    <style type="text/css">
      /* #####################################################################
         #
         #   Project       : Modal Login with jQuery Effects
         #   Author        : Rodrigo Amarante (rodrigockamarante)
         #   Version       : 1.0
         #   Created       : 07/28/2015
         #   Last Change   : 08/02/2015
         #
         ##################################################################### */
         
      @import url(http://fonts.googleapis.com/css?family=Roboto);

      * {
          font-family: 'Roboto', sans-serif;
      }

      #login-modal .modal-dialog {
        width: 330px
      }

      #login-modal input[type=text], input[type=password] {
        margin-top: 10px;
      }

      #div-login-msg,
      #div-lost-msg,
      #div-register-msg {
          border: 1px solid #dadfe1;
          height: 55px;
          line-height: 28px;
          transition: all ease-in-out 500ms;
      }

      #div-login-msg.success,
      #div-lost-msg.success,
      #div-register-msg.success {
          border: 1px solid #68c3a3;
          background-color: #c8f7c5;
      }

      #div-login-msg.error,
      #div-lost-msg.error,
      #div-register-msg.error {
          border: 1px solid #eb575b;
          background-color: #ffcad1;
      }

      #icon-login-msg,
      #icon-lost-msg,
      #icon-register-msg {
          width: 30px;
          float: left;
          line-height: 55px;
          text-align: center;
          background-color: #dadfe1;
          margin-right: 5px;
          transition: all ease-in-out 500ms;
      }

      #icon-login-msg.success,
      #icon-lost-msg.success,
      #icon-register-msg.success {
          background-color: #68c3a3 !important;
      }

      #icon-login-msg.error,
      #icon-lost-msg.error,
      #icon-register-msg.error {
          background-color: #eb575b !important;
      }



      /* #########################################
         #    override the bootstrap configs     #
         ######################################### */

      .modal-backdrop.in {
          filter: alpha(opacity=50);
          opacity: .7;
      }

      .modal-content {
          background-color: #ececea;
          border: 1px solid #bdc3c7;
          border-radius: 0px;
          outline: 0;
      }

      .modal-header {
          min-height: 16.43px;
          padding: 15px 15px 15px 15px;
          border-bottom: 0px;
      }

      .modal-body {
          position: relative;
          padding: 5px 15px 5px 15px;
      }

      .modal-footer {
          padding: 15px 15px 15px 15px;
          text-align: left;
          border-top: 0px;
      }

      .checkbox {
          margin-bottom: 0px;
      }

      .btn {
          border-radius: 0px;
      }

      .btn:focus,
      .btn:active:focus,
      .btn.active:focus,
      .btn.focus,
      .btn:active.focus,
      .btn.active.focus {
          outline: none;
      }

      .btn-lg, .btn-group-lg>.btn {
          border-radius: 0px;
      }

      .btn-link {
          padding: 5px 10px 0px 0px;
          color: #95a5a6;
      }

      .btn-link:hover, .btn-link:focus {
          color: #2c3e50;
          text-decoration: none;
      }

      .glyphicon {
          top: 0px;
      }

      .form-control {
        border-radius: 0px;
      }

      /* #########################################
         Resize Google ReCaptcha hack
         ######################################### */
      #rc-imageselect, .g-recaptcha {
            transform:scale(0.87);
            -webkit-transform:scale(0.87);
            transform-origin:0 0;
            -webkit-transform-origin:0 0;
      }
      
      /* for tooltip */
      .ui-tooltip {
        max-width: 350px;
      }
      /* centered columns styles */
      .row-centered {
          text-align:center;
      }
      .col-centered {
          display:inline-block;
          float:none;
          /* reset the text-align */
          text-align:left;
          /* inline-block space fix */
          margin-right:-4px;
      }
      .col-fixed {
          /* custom width */
          width:350px;
      }        
      
      .footer {
        position: absolute;
        bottom: 0;
        width: 100%;
        /* Set the fixed height of the footer here */
        height: 40px;
        background-color: #f5f5f5;
      }       
    </style>    
    <!--
    <script src="http://code.jquery.com/jquery-1.11.1.min.js"></script>    
    <script src="http://maxcdn.bootstrapcdn.com/bootstrap/3.3.0/js/bootstrap.min.js"></script>
    -->
    
    <!-- jQuery 2.2.3 -->
    <script src="plugins/jQuery/jquery-2.2.3.min.js"></script>
    <!-- Bootstrap 3.3.6 -->
    <script src="bootstrap/js/bootstrap.min.js"></script>

    <!-- Google reCAPTCHA API -->
    <!--<script src='https://www.google.com/recaptcha/api.js'></script>-->
    <script src="https://www.google.com/recaptcha/api.js?onload=CaptchaCallback&render=explicit" async defer></script>
</head>
<body>

<div class="container">
    <div class="row">
      <br>
      <a href="https://iwira.ltat.org.my">
        <img class="img-responsive hidden-lg hidden-md center-block" src="dist/img/LTATLogo3.png">
        <img class="img-responsive hidden-sm hidden-xs center-block" src="dist/img/logo_ltat_587x70.png">
      </a><br>
      <h1 class="text-center">      
      i-Wira<br>      
      <small><a href="https://www.ltat.gov.my/my/i-wira-2.html" target="_blank">Sistem Semakan Caruman Atas Talian</a></small>
      </h1>
      <p class="text-center">Klik <a href="https://www.ltat.gov.my/my/i-wira-2.html" target="_blank">di sini</a> untuk info pengenalan Sistem i-Wira</p>
      
      <br><br><br>
      
      <p class="text-center"><a href="#" class="btn btn-primary btn-lg" role="button" data-toggle="modal" data-target="#login-modal">LOG MASUK</a></p>
	  <!--<h1><p class="text-center">Harap Maaf, sistem sedang diselenggara</p></h1>-->
    </div>
</div>

<!-- BEGIN # MODAL LOGIN -->
<div class="modal fade" id="login-modal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
    <div class="modal-dialog modal-sm">
        <div class="modal-content">
            <div class="modal-header" align="center">
              <img  id="img_logo" src="dist/img/LTATLogo3.png">
              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span class="glyphicon glyphicon-remove" aria-hidden="true"></span>
              </button>
            </div>
                  
            <!-- Begin # DIV Form -->
            <div id="div-forms">        
                <!-- Begin # Login Form -->
                <form id="login-form" action="<?php echo ew_CurrentPage() ?>" method="post">
                <div class="modal-body center-block">
                    <div id="div-login-msg">
                        <div id="icon-login-msg" class="glyphicon glyphicon-chevron-right"></div>
                        <!--<span id="text-login-msg">Type your username and password.</span>-->
                        <span id="text-login-msg">Sila masukkan Nombor Tentera & seterusnya Kata Laluan anda</span>
                    </div>

                    <div id="loginid">
                        <input id="login_username" name="armyno" class="form-control" type="text" placeholder="No Tentera" values="<?php echo $uname; ?>" required>
                    </div>
                    <div id="loginpwd">
                        <!--<input id="login_password" name="userpassword" class="form-control" type="password" placeholder="Kata Laluan" required>-->
                    </div>
                    <p>
                    
                    <!--
                    <div class="checkbox">
                        <label>
                            <input type="checkbox"> Remember me
                        </label>
                    </div>
                    -->
                    <!-- Google Recaptcha here -->
                    <!--<p><div class="g-recaptcha" data-size="normal" data-sitekey="6LfM3yUTAAAAAJBkHNnZNKtx0xARtQ3N-FwwX_HQ"></div>-->

                    <div class="callout callout-info">
                      Sila pastikan akaun anda telah diaktifkan melalui emel sebelum log masuk.
                    </div>
                    <div id="resendactivation">
                      
                    </div>
                    
                    
                </div>
                <div class="modal-footer">
                    <div>
                        <div id="loginnext">
                          <button type="button" name="btn-next" class="btn btn-primary btn-lg btn-block" value="Next" onclick="checkLoginID();">Seterusnya</button>
                        </div>                        
                        <div id="loginsubmit" class="btn-group btn-group-justified">
                          <div class="btn-group" style="width: 15%">
                            <!--<button type="button" name="btn-home" class="btn btn-primary btn-lg" value="Home"><i class="fa fa-arrow-left"></i></button>-->
                            <a href="login.php" class="btn btn-primary btn-lg"><i class="fa fa-arrow-left"></i></a>
                          </div>
                          <div class="btn-group" style="width: 85%">
                            <button type="submit" name="btn-login" id="btn-login" class="btn btn-primary btn-lg" value="Login">Login</button>
                          </div>
                        </div>
                    </div>
                    <div>
                        <button id="login_lost_btn" type="button" class="btn btn-link">Lupa Kata Laluan?</button>
                        <button id="login_register_btn" type="button" class="btn btn-link">Pendaftaran i-Wira</button>
                    </div>
                </div>
                </form>
                <!-- End # Login Form -->
                
                <!-- Begin | Lost Password Form -->
                <form id="lost-form" style="display:none;" action="<?php echo ew_CurrentPage() ?>" method="post">
                <div class="modal-body center-block">
                    <div id="div-lost-msg">
                        <div id="icon-lost-msg" class="glyphicon glyphicon-chevron-right"></div>
                        <span id="text-lost-msg">Sila masukkan Nombor Tentera anda</span>
                    </div>
                    <input id="lost_armyno" name="armyno" class="form-control" type="text" placeholder="No Tentera" required>
                    
                    <!-- Google Recaptcha here -->
                    <p><div class="g-recaptcha" data-size="normal" data-sitekey="6LfM3yUTAAAAAJBkHNnZNKtx0xARtQ3N-FwwX_HQ"></div>
                    
                </div>
                <div class="modal-footer">
                    <div>
                        <button type="submit" name="btn-forgotpwd" class="btn btn-primary btn-lg btn-block" value="Forgot Password">Hantar Emel</button>
                    </div>
                    <div>
                        <button id="lost_login_btn" type="button" class="btn btn-link">Log Masuk</button>
                        <button id="lost_register_btn" type="button" class="btn btn-link">Pendaftaran i-Wira</button>
                    </div>
                </div>
                </form>
                <!-- End | Lost Password Form -->
                
                <!-- Begin | Register Form -->
                <form id="register-form" style="display:none;" action="<?php echo ew_CurrentPage() ?>" method="post">
                <div class="modal-body center-block">
                    <div id="div-register-msg">
                        <div id="icon-register-msg" class="glyphicon glyphicon-chevron-right"></div>
                        <span id="text-register-msg">Pendaftaran akaun i-Wira</span>
                    </div>
                    <input id="register_username"         name="armyno"              class="form-control" type="text"     placeholder="No Tentera" required>
                    <input id="register_email"            name="useremail"           class="form-control" type="text"     placeholder="Emel" required>
                    <input id="register_secureword"       name="secureword"          class="form-control" type="text"     placeholder="Secure Word" maxlength="20" data-minlength="5" pattern="[A-Za-z0-9]{5,20}" required title="Must be between 5-20 characters" oninvalid="this.setCustomValidity('Must be between 5-20 characters')" onchange="try{setCustomValidity('')}catch(e){}">
                    <input id="register_password"         name="userpassword"        class="form-control" type="password" placeholder="Kata Laluan"  data-minlength="6" pattern="(?=^.{6,}$)((?=.*\d)|(?=.*\W+))(?![.\n])(?=.*[A-Z])(?=.*[a-z]).*$" required oninvalid="this.setCustomValidity('Sekurang-kurangnya 8 aksara atau lebih dan perlu memenuhi 4 jenis aksara berikut: Huruf besar [ABC], huruf kecil [abc], nombor [123] dan simbol [@#$]')" onchange="try{setCustomValidity('')}catch(e){}">
                    <!--<input id="register_password"         name="userpassword"        class="form-control" type="password" placeholder="Kata Laluan"  data-minlength="6" pattern="(?=^.{6,}$)((?=.*\d)|(?=.*\W+))(?![.\n])(?=.*[A-Z])(?=.*[a-z]).*$" required oninvalid="this.setCustomValidity('Min 6 karakter, gabungan 1 abjab, 1 angka dan 1 simbol.')" onchange="try{setCustomValidity('')}catch(e){}">-->                  
                    <input id="register_password_confirm" name="userpasswordconfirm" class="form-control" type="password" placeholder="Sah Kata Laluan" data-minlength="6" data-match="#register_password" required>
                    
                    <!-- Google Recaptcha here -->
                    <!--<p><div class="g-recaptcha" data-size="normal" data-sitekey="6LfM3yUTAAAAAJBkHNnZNKtx0xARtQ3N-FwwX_HQ"></div>-->
                    
                </div>
                <div class="modal-footer">
                    <div>
                        <button type="submit" name="btn-register" class="btn btn-primary btn-lg btn-block" value="Register">Daftar</button>
                    </div>
                    <div>
                        <button id="register_login_btn" type="button" class="btn btn-link">Log Masuk</button>
                        <button id="register_lost_btn" type="button" class="btn btn-link">Lupa Kata Laluan?</button>
                    </div>
                </div>
                </form>
                <!-- End | Register Form -->
                
            </div>
            <!-- End # DIV Form -->

        </div>
		</div>
</div>    
    <!-- END # MODAL LOGIN -->
    
    
<div class="container">
  <p class="text-center">Dengan klik butang diatas, anda telah bersetuju dengan <a href="http://www.ltat.org.my/borg/iWiraT&C.pdf" target="_blank">Terma dan Syarat</a> yang telah ditetapkan.</p>
  <div class="row row-centered">
    <div class="col-md-2 col-centered">
      <a class="btn btn-block" href="http://www.ltat.org.my/borg/panduaniWira.pdf" target="_blank">
          <i class="fa fa-book"></i> Manual Sistem i-Wira
      </a>
    </div>
  </div>
</div>

<footer class="footer">
    <p>
    <div class="container">
      <div class="pull-right hidden-xs">
        <b>Versi</b> 1.1.0
      </div>
      <div class="pull-left"><strong>&copy; 2017 <a href="http://www.ltat.org.my">Lembaga Tabung Angkatan Tentera</a>.</strong></div><div class="pull-left hidden-xs">&nbsp;Hak Cipta Terpelihara.</div>
    </div>

</footer>

    <!-- END # MODAL LOGIN -->
    
<!-- jQueryUI 1.11.4 -->
<script src="plugins/jQueryUI/jquery-ui.min.js"></script>    
    
<script type="text/javascript">
/* #####################################################################
   #
   #   Project       : Modal Login with jQuery Effects
   #   Author        : Rodrigo Amarante (rodrigockamarante)
   #   Version       : 1.0
   #   Created       : 07/29/2015
   #   Last Change   : 08/04/2015
   #
   ##################################################################### */
   
$("document").ready(function() {
  $("#loginsubmit").hide().css("visibility", "hidden");
});
   
   
//$(function() {
    
    var $formLogin        = $('#login-form');
    var $formLost         = $('#lost-form');
    var $formRegister     = $('#register-form');
    var $divForms         = $('#div-forms');
    var $modalAnimateTime = 100;
    var $msgAnimateTime   = 150;
    var $msgShowTime      = 7000;

    <?php if($loginError):?>
          $('#login-modal').modal('show');
          msgChange($('#div-login-msg'), $('#icon-login-msg'), $('#text-login-msg'), "error", "glyphicon-remove", "<?php echo $errorMsg; ?>");      
    <?php endif;?>

    <?php if($registerError):?>
          $('#login-modal').modal('show');
          
          <?php if ($registerOk){ ?>
              msgChange($('#div-login-msg'), $('#icon-login-msg'), $('#text-login-msg'), "success", "glyphicon-ok", "<?php echo $errorMsg; ?>");
              showResendActivationEmail();
          <?php
          } else {
          ?>
              window.setTimeout(function(){
                 // do whatever you want to do
                 $('#login_register_btn').trigger("click");
              }, 300);
              //msgChange($('#div-login-msg'), $('#icon-login-msg'), $('#text-login-msg'), "error", "glyphicon-remove", "<?php echo $errorMsg; ?>");      
              msgChange($('#div-register-msg'), $('#icon-register-msg'), $('#text-register-msg'), "error", "glyphicon-remove", "<?php echo $errorMsg; ?>");      
          <?php    
          }
          ?>
    <?php endif;?>

   <?php if($lostpwdError):?>
          $('#login-modal').modal('show');
          
          <?php if ($lostpwdOk){ ?>          
              //msgChange($('#div-lost-msg'), $('#icon-lost-msg'), $('#text-lost-msg'), "success", "glyphicon-ok", "<?php echo $errorMsg; ?>");      
              msgChange($('#div-login-msg'), $('#icon-login-msg'), $('#text-login-msg'), "success", "glyphicon-ok", "<?php echo $errorMsg; ?>");      
          <?php
          } else {
          ?>
              window.setTimeout(function(){
                 // do whatever you want to do
                 $('#login_lost_btn').trigger("click");
              }, 300);
              msgChange($('#div-lost-msg'), $('#icon-lost-msg'), $('#text-lost-msg'), "error", "glyphicon-remove", "<?php echo $errorMsg; ?>");      
          <?php    
          }
          ?>
    <?php endif;?>    
    
    $('#login_register_btn').click( function () { modalAnimate($formLogin, $formRegister) });
    $('#register_login_btn').click( function () { modalAnimate($formRegister, $formLogin); });
    $('#login_lost_btn').click( function ()     { modalAnimate($formLogin, $formLost); });
    $('#lost_login_btn').click( function ()     { modalAnimate($formLost, $formLogin); });
    $('#lost_register_btn').click( function ()  { modalAnimate($formLost, $formRegister); });
    $('#register_lost_btn').click( function ()  { modalAnimate($formRegister, $formLost); });
    
    function modalAnimate ($oldForm, $newForm) {
        var $oldH = $oldForm.height();
        var $newH = $newForm.height();
        $divForms.css("height",$oldH);
        $oldForm.fadeToggle($modalAnimateTime, function(){
            $divForms.stop().animate({height: $newH}, $modalAnimateTime, function(){
                $newForm.fadeToggle($modalAnimateTime);
            });
        });
    }
    
    function msgFade ($msgId, $msgText) {
        $msgId.fadeOut($msgAnimateTime, function() {
            $(this).text($msgText).fadeIn($msgAnimateTime);
        });
    }
    
    function msgChange($divTag, $iconTag, $textTag, $divClass, $iconClass, $msgText) {
        var $msgOld = $divTag.text();
        msgFade($textTag, $msgText);
        $divTag.addClass($divClass);
        $iconTag.removeClass("glyphicon-chevron-right");
        $iconTag.addClass($iconClass + " " + $divClass);
        setTimeout(function() {
            msgFade($textTag, $msgOld);
            $divTag.removeClass($divClass);
            $iconTag.addClass("glyphicon-chevron-right");
            $iconTag.removeClass($iconClass + " " + $divClass);
  		}, $msgShowTime);
    }
    
  function showResendActivationEmail(){
      $("#resendactivation").html("<?php echo $resendactivation; ?>");      
  }  
    
    
  $('#btnResendActivation').click(function(){
  //function resendActivationEmail() {
      //alert("hi!");
      //var userID = document.getElementById("register_username").value;
      var userID = "<?php if ($uname=="") { echo ""; } else { echo $uname;} ?>";
      
      if (userID==""){
        msgChange($('#div-login-msg'), $('#icon-login-msg'), $('#text-login-msg'), "error", "glyphicon-remove", "No Tentera diperlukan");
      } else {
            
        //alert(userID);
        $.ajax({
            type: 'POST',
            url:  'ajax_resendactivationemail.php',
            data: {loginID: userID},
            dataType: 'text',
            success: function(data){
              //if (data=="success"){
            //    $("#resendactivation").html("<?php echo $resendactivation; ?>");
                msgChange($('#div-login-msg'), $('#icon-login-msg'), $('#text-login-msg'), "success", "glyphicon-ok", "Emel pengaktifan telah dihantar semula!");
            },
            error: function(xhr) {
              //Do Something to handle error
              alert("Oops! There's something wrong with the system. Please try again later!");
            }
        });
      }
  });
    
    $( "#register_secureword" ).tooltip({ 
                                     content: '<div class="container">'     +
                                              '  <div class="row row-centered">'         +
                                              '    <div class="col-md-12 col-fixed">' +
                                              '      <div class="text-red text-bold"><i class="fa fa-lg fa-info-circle text-aqua"></i>&nbsp&nbsp;SecureWord Sample</div>' +
                                              '    </div>' +
                                              '  </div>'   +
                                              '  <div class="row row-centered">'         +
                                              '    <div class="col-md-12 col-fixed">' +
                                              '      <img src="dist/img/sampleSecureWord.png" />' +
                                              '    </div>' +
                                              '  </div>'   +
                                              '  <div class="row">'         +
                                              '    <div class="col-md-12 col-fixed">' +
                                              '      Anda diminta untuk mewujudkan SecureWord<br>        ' +
                                              '      anda. SecureWord ini bukan kata laluan              ' +
                                              '      anda. SecureWord ini akan digunakan untuk           ' +
                                              '      mengesahkan bahawa anda telah masuk ke laman<br>    ' +
                                              '      Sistem i-Wira yang sah. Anda boleh memilih <br>     ' +
                                              '      mana-mana perkataan sehingga 20 abjad dan/atau      ' +
                                              '      angka. Penggunaan simbol adalah tidak dibenarkan.   ' +
                                              '    </div>' +
                                              '  </div>'   +
                                              '</div>',
                                     position: {
                                       my: "left top",
                                       at: "right bottom"                                           
                                       
                                     }
                                     
                                   });     
    
    
    
//});
</script>

<script type="text/javascript">
  function checkLoginID() {
      //alert("hi!");
      var userID = document.getElementById("login_username").value;
      
      if (userID==""){
        msgChange($('#div-login-msg'), $('#icon-login-msg'), $('#text-login-msg'), "error", "glyphicon-remove", "No Tentera diperlukan");
      } else {
            
        //alert(userID);
        $.ajax({
            type: 'POST',
            url:  'ajax_checkloginid.php',
            data: {loginID: userID},
            dataType: 'text',
            success: function(data){
              //if (data=="success"){
                $("#loginid").hide().css("visibility", "hidden");
                $("#loginnext").hide().css("visibility", "hidden");
                $("#loginsubmit").show().css("visibility", "visible");
                //$("#loginpwd").html("<br><img src=\"showsecurephrase.php\"><br><input id=\"login_password\" name=\"userpassword\" class=\"form-control\" type=\"password\" placeholder=\"Kata Laluan\" required><br><p class=\"small text-center\">Jangan teruskan jika ini bukan 'SecureWord' anda</p><p class=\"text-center\"><input name=\"checkbox-issecureword\" type=\"checkbox\" onclick=\"isSecureWord();\">&nbsp;Ya, ini 'SecureWord' saya</p>");
                //$("#loginpwd").html("<br>"+data+"<br><input id=\"login_password\" name=\"userpassword\" class=\"form-control\" type=\"password\" placeholder=\"Kata Laluan\" required><br><p class=\"small text-center\">Jangan teruskan jika ini bukan 'SecureWord' anda</p><p class=\"text-center\"><input name=\"checkbox-issecureword\" type=\"checkbox\" onclick=\"isSecureWord();\">&nbsp;Ya, ini 'SecureWord' saya</p>");
                $("#loginpwd").html("<br>"+data+"<br><br><p class=\"small text-center\">Jangan teruskan jika ini bukan 'SecureWord' anda</p><p class=\"text-center\"><input name=\"checkbox-issecureword\" type=\"checkbox\" onclick=\"isSecureWord();\">&nbsp;Ya, ini 'SecureWord' saya</p><input id=\"login_password\" name=\"userpassword\" class=\"form-control\" type=\"password\" placeholder=\"Kata Laluan\" required>");
                $("#btn-login").prop('disabled', true);
                $("#login_password").prop('disabled', true);
              //} else {
              //  msgChange($('#div-login-msg'), $('#icon-login-msg'), $('#text-login-msg'), "error", "glyphicon-remove", "Incorrect login credential");      
              //}
            },
            error: function(xhr) {
              //Do Something to handle error
              alert("Oops! There's something wrong with the system. Please try again later!");
            }
        });
      }
  }
  

  
  function isSecureWord(){
    if ( $('input[name="checkbox-issecureword"]').is(':checked') ) {
      $("#login_password").prop('disabled', false);
      $("#btn-login").prop('disabled', false);
      $("#login_password").focus();
    } else {
      $("#login_password").prop('disabled', true);
      $("#btn-login").prop('disabled', true);
    }
    
    //var chk = $("#checkbox-issecureword");
    //if (chk.checked){
    //  $("#login_password").prop('disabled', false);      
    //} else {    
    //  $("#login_password").prop('disabled', true);
   // }
  }
  
  function validatePassword(){
    var userPwd = document.getElementById("login_password").value;
    if (userPwd==""){
      msgChange($('#div-login-msg'), $('#icon-login-msg'), $('#text-login-msg'), "error", "glyphicon-remove", "Password is mandatory");
    }
  }
  
 
</script>

<script>
    var CaptchaCallback = function() {
      $('.g-recaptcha').each(function(index, el) {
        grecaptcha.render(el, {'sitekey' : '6LfM3yUTAAAAAJBkHNnZNKtx0xARtQ3N-FwwX_HQ'});
      });
    };
</script>

<!-- Default Statcounter code for i-Wira https://iwira.ltat.org.my/ -->
<script type="text/javascript">
var sc_project=12000535; 
var sc_invisible=1; 
var sc_security="98f16c2c"; 
var sc_https=1; 
</script>
<script type="text/javascript"
src="https://www.statcounter.com/counter/counter.js" async></script>
<noscript><div class="statcounter"><a title="Web Analytics Made Easy -
StatCounter" href="https://statcounter.com/" target="_blank"><img
class="statcounter" src="https://c.statcounter.com/12000535/0/98f16c2c/1/"
alt="Web Analytics Made Easy - StatCounter"></a></div></noscript>
<!-- End of Statcounter Code -->
</body>
</html>
