<?php include_once "header.php" ?>
<?php require_once "plugins/htmlpurifier-4.9.2-lite/library/HTMLPurifier.auto.php"; ?>

<?php


if ($_SESSION[EW_SESSION_SYS_ADMIN] == 0 && $_SESSION[EW_SESSION_USER_LEVEL]!=50) {
    $disabled        = "disabled";
    $mailto          = "JHEKP";
    $subjectdisabled = "";
} else {
    $disabled        = "";
    $mailto          = ew_RemoveXSS(ew_StripSlashes($_POST['inputTo']));;
    $subjectdisabled = "";
}

if(isset($_POST['inputReply'])) {
    $parentid        = ew_RemoveXSS(ew_StripSlashes($_POST['inputParentID']));
    $mailto          = ew_RemoveXSS(ew_StripSlashes($_POST['inputTo']));
    $mailsubject     = ew_RemoveXSS(ew_StripSlashes($_POST['inputSubject']));
    $subjectdisabled = "disabled"; // if page comes from clicking reply, subject cannot change, follow main thread
}

if(isset($_POST['inputSubmit'])) {
    $parentid    = ew_RemoveXSS(ew_StripSlashes($_POST['inputParentID'])); // have value if submitted from reply
    $mailto      = ew_RemoveXSS(ew_StripSlashes($_POST['inputTo']));
    $mailsubject = ew_RemoveXSS(ew_StripSlashes($_POST['inputSubject']));
    $dirty_html  = $_POST['inputContent'];

    // now we load htmlpurifier to filter out those naughty code injections *tsk* *tsk*
    $config      = HTMLPurifier_Config::createDefault();
    $purifier    = new HTMLPurifier($config);
    $clean_html  = $purifier->purify($dirty_html);

    $lastinsertid = "";


    if (isset($parentid) && ($parentid!=="")){
        // INSERT INTO MAILBOX TABLE
        $stmt = $DB_con->prepare("INSERT INTO MAILBOX
                                  (
                                     PARENTID
                                    ,MAILFROM
                                    ,MAILTO
                                    ,MAILSUBJECT
                                    ,MAILMESSAGE
                                    ,MAILREAD
                                    ,DATECREATED
                                  ) VALUES (
                                     :pid
                                    ,:uid
                                    ,:umailto
                                    ,:usubject
                                    ,:umsg
                                    ,0
                                    ,getdate()
                                  )
                                 ");
        $stmt->bindparam(":pid",      $parentid);
        $stmt->bindparam(":uid",      $user_id);
        $stmt->bindparam(":umailto",  $mailto);
        $stmt->bindparam(":usubject", $mailsubject);
        $stmt->bindparam(":umsg",     $clean_html);
        $stmt->execute();

        // UPDATE MAIL AS unREAD
        $sql = "UPDATE MAILBOX
                   SET MAILREAD=0
                 WHERE ID      =:parentid
                   AND PARENTID IS NULL
               ";
        $stmt = $DB_con->prepare($sql);
        $stmt->bindparam(":parentid", $parentid);
        $stmt->execute();

    } else {
        // INSERT INTO MAILBOX TABLE
        $stmt = $DB_con->prepare("INSERT INTO MAILBOX
                                  (
                                     MAILFROM
                                    ,MAILTO
                                    ,MAILSUBJECT
                                    ,MAILMESSAGE
                                    ,MAILREAD
                                    ,DATECREATED
                                  ) VALUES (
                                     :uid
                                    ,:umailto
                                    ,:usubject
                                    ,:umsg
                                    ,0
                                    ,getdate()
                                  )
                                 ");
        $stmt->bindparam(":uid",      $user_id);
        $stmt->bindparam(":umailto",  $mailto);
        $stmt->bindparam(":usubject", $mailsubject);
        $stmt->bindparam(":umsg",     $clean_html);
        $stmt->execute();
        $lastinsertid = $DB_con->lastInsertId();
    }

    header("location: mailbox.php?success=1&ticketID=$lastinsertid");
}




?>

  <!-- bootstrap wysihtml5 - text editor -->
  <link rel="stylesheet" href="plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.min.css">

<!-- Full Width Column -->
<div class="content-wrapper">
    <div class="container">
        <!-- Content Header (Page header) -->
        <section class="content-header">
          <h1>
            Maklum Balas
            <small><?php echo $totalData;?> mesej baru</small>
          </h1>
          <ol class="breadcrumb">
            <li><a href="index.php"><i class="fa fa-dashboard"></i> Laman Utama</a></li>
            <li>Maklum Balas</li>
            <li class="active">Karang</li>
          </ol>
        </section>

        <!-- Main content -->
        <section class="content">
          <div class="row">
            <div class="col-md-3">
              <a href="mailbox.php" class="btn btn-primary btn-block margin-bottom">Kembali ke Maklum Balas</a>

              <div class="box box-solid">
                <div class="box-header with-border">
                  <h3 class="box-title">Folders</h3>

                  <div class="box-tools">
                    <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                    </button>
                  </div>
                </div>
                <div class="box-body no-padding">
                  <ul class="nav nav-pills nav-stacked">
                    <li><a href="mailbox.php"><i class="fa fa-inbox"></i> Maklum Balas
                      <span class="label label-primary pull-right"><?php echo $totalData;?></span></a></li>
                    <!--<li><a href="#"><i class="fa fa-envelope-o"></i> Sent</a></li>-->
                  </ul>
                </div>
                <!-- /.box-body -->
              </div>
              <!-- /. box -->
            </div>
            <!-- /.col -->
            <div class="col-md-9">
              <div class="box box-primary">
                <form id="mailcompose-form" action="<?php echo htmlspecialchars(ew_CurrentPage()) ?>" role="form" method="POST">
                    <input type="hidden" name="inputParentID" value="<?php echo $parentid;?>">
                    <div class="box-header with-border">
                      <h3 class="box-title">Karang Mesej Baru</h3>
                    </div>
                    <!-- /.box-header -->
                    <div class="box-body">
                        <div class="form-group">
                          <input name="inputTo" id="inputTo" class="form-control" placeholder="To:" value="<?php echo $mailto;?>" <?php echo $disabled;?>>
                        </div>
                        <div class="form-group">
                          <input name="inputSubject" id="inputSubject" class="form-control" placeholder="Subject:" value="<?php echo $mailsubject;?>" <?php echo $subjectdisabled;?> required>
                        </div>
                        <div class="form-group">
                              <textarea name="inputContent" id="inputContent" class="form-control" style="height: 250px" required>

                              </textarea>
                        </div>

                    </div>
                    <!-- /.box-body -->
                    <div class="box-footer">
                      <div class="pull-right">
                        <!--<button type="button" class="btn btn-default"><i class="fa fa-pencil"></i> Draft</button>-->
                        <button type="submit" name="inputSubmit" class="btn btn-primary"><i class="fa fa-envelope-o"></i> Hantar</button>
                      </div>
                      <button type="reset" class="btn btn-default"><i class="fa fa-times"></i> Abai Perubahan</button>
                    </div>
                    <!-- /.box-footer -->
                </form>
              </div>
              <!-- /. box -->
            </div>
            <!-- /.col -->
          </div>
          <!-- /.row -->
        </section>
        <!-- /.content -->


    </div>
    <!-- /.content-wrapper -->
</div>

<?php include_once "footer.php" ?>
<!-- Bootstrap WYSIHTML5 -->
<script src="plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.all.min.js"></script>
<script>
  $(function () {
    //Add text editor
    $("#inputContent").wysihtml5({toolbar: {"image":false}});

  });

  $('#mailcompose-form').submit(function() {
    $("#inputSubject").prop('disabled', false);
    $("#inputTo").prop('disabled', false);
    //Rest of code
  })
</script>