package config

import "code.justin.tv/chat/jsonconf"

type Config struct {
	Port      int `json:"port"`
	DebugPort int `json:"debug_port"`

	Stats StatsConfig `json:"stats"`

	SiteDB DBConfig `json:"site_read_db"`

	Rollbar RollbarConfig `json:"rollbar"`
}

type StatsConfig struct {
	Host   string `json:"host" validate:"nonzero"`
	Port   int    `json:"port" validate:"min=1,max=65535"`
	Prefix string `json:"prefix" validate:"nonzero"`
}

type DBConfig struct {
	Host string `json:"host" validate:"nonzero"`
	Port int    `json:"port" validate:"min=1,max=65535"`

	Name     string `json:"dbname" validate:"nonzero"`
	User     string `json:"user" validate:"nonzero"`
	Password string `json:"password" validate:"nonzero"`

	MaxOpenConns       int               `json:"max_open_connections" validate:"min=1"`
	MaxIdleConns       int               `json:"max_idle_connections" validate:"min=1"`
	ConnQueueSize      int               `json:"conn_queue_size" validate:"min=0"`
	ConnAcquireTimeout jsonconf.Duration `json:"conn_acquire_timeout" validate:"duration_min=1ms"`
	RequestTimeout     jsonconf.Duration `json:"request_timeout" validate:"duration_min=1ms"`
	MaxConnAge         jsonconf.Duration `json:"max_conn_age" validate:"duration_min=1ms"`

	StatsPrefix string `json:"stats_prefix" validate:"nonzero"`
	LogQueries  bool   `json:"log_queries"`
}
type RollbarConfig struct {
	// Token is optional
	Token       string `json:"token"`
	Environment string `json:"environment" validate:"nonzero"`
}

type TwitchHTTPConfig struct {
	// NOTE: Host should include scheme and port (if needed)
	Host string `json:"host" validate:"nonzero"`

	MaxIdleConns int `json:"max_idle_conns" validate:"min=1"`
}
