db
==

A robust golang sql database client focused on reliability and visibility.  This library supports the following features:

* Dynamically reconfigurable connection pools. Includes support for hot config reloads
* Configurable automatic recycling of connections.  For example if we replace all our connections every minute, we can make changes to haproxy and avoid using the old haproxy backend connections.  We cannot do this without recycling, because haproxy connections persist even across a haproxy restart.
* A view into the state of the client at a point in time, including:
  * The size of the current pool size
  * The maximum number of concurrent open connections open over a duration
  * The minimum number of available connections over a duration
  * The time since the last connection recycle trigger
  * The time of the last configuration reload
* Callbacks for instrumentation support:
  * How long it took to acquire a connection
  * How long it took to execute an operation, for both successes and failures
* Context support for all operations - https://blog.golang.org/context
* Timeouts - sql.DB doesn't support timeouts on the underlying connections, but calls to chatdb spin up a goroutine and will return within the specified timeout threshold.
