package dbplus

import (
	"time"

	_ "github.com/lib/pq"

	"code.justin.tv/chat/db"
)

type Config struct {
	Host string
	Port int

	Name     string
	User     string
	Password string

	MaxOpenConns  int
	MaxIdleConns  int
	ConnQueueSize int

	StatsPrefix string
	LogQueries  bool

	ConnAcquireTimeout time.Duration
	RequestTimeout     time.Duration
	MaxConnAge         time.Duration
}

func OpenDB(conf Config) (db.DB, error) {
	return db.Open(
		db.DriverName("postgres"),
		db.Host(conf.Host),
		db.Port(conf.Port),
		db.User(conf.User),
		db.Password(conf.Password),
		db.DBName(conf.Name),
		db.MaxOpenConns(conf.MaxOpenConns),
		db.MaxIdleConns(conf.MaxIdleConns),
		db.MaxQueueSize(conf.ConnQueueSize),
		db.ConnAcquireTimeout(time.Duration(conf.ConnAcquireTimeout)),
		db.RequestTimeout(time.Duration(conf.RequestTimeout)),
		db.MaxConnAge(time.Duration(conf.MaxConnAge)),
	)
}
