package gojiplus

import "net/http"

// ResponseWriter implements http.ResponseWriter.
type ResponseWriter struct {
	http.ResponseWriter
	status int
}

// WriteHeader writes a status code.
func (w *ResponseWriter) WriteHeader(status int) {
	w.status = status
	w.ResponseWriter.WriteHeader(status)
}

// Write writes a response body. Also writes a 200 OK status if no status
// was explcitly set.
func (w *ResponseWriter) Write(b []byte) (int, error) {
	if w.status == 0 {
		w.WriteHeader(http.StatusOK)
	}
	return w.ResponseWriter.Write(b)
}

// Status returns the written status code. 0 is returned if no status was written.
func (w *ResponseWriter) Status() int {
	return w.status
}
